/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.mr;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.AbstractMapOperator;
import org.apache.hadoop.hive.ql.exec.MapOperator;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapperContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorMapOperator;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecMapper
extends MapReduceBase
implements Mapper {
    private AbstractMapOperator mo;
    private OutputCollector oc;
    private JobConf jc;
    private boolean abort = false;
    private Reporter rp;
    public static final Logger l4j = LoggerFactory.getLogger(ExecMapper.class);
    private static boolean done;
    private MapredLocalWork localWork = null;
    private ExecMapperContext execContext = null;

    public void configure(JobConf job) {
        this.execContext = new ExecMapperContext(job);
        Utilities.tryLoggingClassPaths(job, l4j);
        ExecMapper.setDone(false);
        try {
            this.jc = job;
            this.execContext.setJc(this.jc);
            MapWork mrwork = Utilities.getMapWork((Configuration)job);
            CompilationOpContext runtimeCtx = new CompilationOpContext();
            this.mo = mrwork.getVectorMode() ? new VectorMapOperator(runtimeCtx) : new MapOperator(runtimeCtx);
            this.mo.setConf(mrwork);
            this.mo.initialize((Configuration)job, null);
            this.mo.setChildren((Configuration)job);
            l4j.info(this.mo.dump(0));
            this.localWork = mrwork.getMapRedLocalWork();
            this.execContext.setLocalWork(this.localWork);
            MapredContext.init(true, new JobConf((Configuration)this.jc));
            this.mo.passExecContext(this.execContext);
            this.mo.initializeLocalWork((Configuration)this.jc);
            this.mo.initializeMapOperator((Configuration)this.jc);
            if (this.localWork == null) {
                return;
            }
            l4j.info("Initializing dummy operator");
            List<Operator<? extends OperatorDesc>> dummyOps = this.localWork.getDummyParentOp();
            for (Operator<? extends OperatorDesc> dummyOp : dummyOps) {
                dummyOp.passExecContext(this.execContext);
                dummyOp.initialize((Configuration)this.jc, null);
            }
        }
        catch (Throwable e) {
            this.abort = true;
            if (e instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)e;
            }
            throw new RuntimeException("Map operator initialization failed", e);
        }
    }

    public void map(Object key, Object value, OutputCollector output, Reporter reporter) throws IOException {
        if (this.oc == null) {
            this.oc = output;
            this.rp = reporter;
            OperatorUtils.setChildrenCollector(this.mo.getChildOperators(), output);
            this.mo.setReporter(this.rp);
            MapredContext.get().setReporter(reporter);
        }
        this.execContext.resetRow();
        try {
            if (this.mo.getDone()) {
                done = true;
            } else {
                this.mo.process((Writable)value);
            }
        }
        catch (Throwable e) {
            this.abort = true;
            if (e instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)e;
            }
            l4j.error(StringUtils.stringifyException((Throwable)e));
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.oc == null) {
            l4j.trace("Close called. no row processed by map.");
        }
        if (!this.abort) {
            this.abort = this.execContext.getIoCxt().getIOExceptions();
        }
        try {
            this.mo.close(this.abort);
            if (this.localWork != null) {
                List<Operator<? extends OperatorDesc>> dummyOps = this.localWork.getDummyParentOp();
                for (Operator<? extends OperatorDesc> dummyOp : dummyOps) {
                    dummyOp.close(this.abort);
                }
            }
            ReportStats rps = new ReportStats(this.rp, (Configuration)this.jc);
            this.mo.preorderMap(rps);
            return;
        }
        catch (Exception e) {
            if (!this.abort) {
                l4j.error("Hit error while closing operators - failing tree");
                throw new RuntimeException("Hive Runtime Error while closing operators", e);
            }
        }
        finally {
            MapredContext.close();
            Utilities.clearWorkMap((Configuration)this.jc);
        }
    }

    public static boolean getDone() {
        return done;
    }

    public boolean isAbort() {
        return this.abort;
    }

    public void setAbort(boolean abort) {
        this.abort = abort;
    }

    public static void setDone(boolean done) {
        ExecMapper.done = done;
    }

    public static class ReportStats
    implements Operator.OperatorFunc {
        private final Reporter rp;
        private final String groupName;

        public ReportStats(Reporter rp, Configuration conf) {
            this.rp = rp;
            this.groupName = HiveConf.getVar(conf, HiveConf.ConfVars.HIVECOUNTERGROUP);
        }

        public void func(Operator op) {
            Map<String, Long> opStats = op.getStats();
            for (Map.Entry<String, Long> e : opStats.entrySet()) {
                if (this.rp == null) continue;
                this.rp.incrCounter(this.groupName, e.getKey(), e.getValue().longValue());
            }
        }
    }
}

