/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.split.SplitLocationProvider;
import org.apache.hive.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.com.google.common.base.Preconditions;
import org.apache.hive.com.google.common.hash.Hashing;
import org.apache.hive.common.util.Murmur3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostAffinitySplitLocationProvider
implements SplitLocationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(HostAffinitySplitLocationProvider.class);
    private final boolean isDebugEnabled = LOG.isDebugEnabled();
    private final List<String> locations;

    public HostAffinitySplitLocationProvider(List<String> knownLocations) {
        Preconditions.checkState(knownLocations != null && !knownLocations.isEmpty(), HostAffinitySplitLocationProvider.class.getName() + " needs at least 1 location to function");
        this.locations = knownLocations;
    }

    public String[] getLocations(InputSplit split) throws IOException {
        String[] stringArray;
        if (!(split instanceof FileSplit)) {
            if (this.isDebugEnabled) {
                LOG.debug("Split: " + split + " is not a FileSplit. Using default locations");
            }
            return split.getLocations();
        }
        FileSplit fsplit = (FileSplit)split;
        String splitDesc = "Split at " + fsplit.getPath() + " with offset= " + fsplit.getStart() + ", length=" + fsplit.getLength();
        String location = this.locations.get(HostAffinitySplitLocationProvider.determineLocation(this.locations, fsplit.getPath().toString(), fsplit.getStart(), splitDesc));
        if (location != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = location;
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    @VisibleForTesting
    public static int determineLocation(List<String> locations, String path, long start, String desc) {
        byte[] bytes = HostAffinitySplitLocationProvider.getHashInputForSplit(path, start);
        long hash1 = HostAffinitySplitLocationProvider.hash1(bytes);
        int index = Hashing.consistentHash(hash1, locations.size());
        String location = locations.get(index);
        if (LOG.isDebugEnabled()) {
            LOG.debug(desc + " mapped to index=" + index + ", location=" + location);
        }
        long hash2 = 0L;
        for (int iter = 1; location == null && iter < locations.size() * 2; ++iter) {
            if (iter == 1) {
                hash2 = HostAffinitySplitLocationProvider.hash2(bytes);
            }
            index = Hashing.consistentHash(hash1 + (long)iter * hash2, locations.size());
            location = locations.get(index);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug(desc + " remapped to index=" + index + ", location=" + location);
        }
        return index;
    }

    private static byte[] getHashInputForSplit(String path, long start) {
        byte[] pathBytes = path.getBytes();
        byte[] allBytes = new byte[pathBytes.length + 8];
        System.arraycopy(pathBytes, 0, allBytes, 0, pathBytes.length);
        SerDeUtils.writeLong(allBytes, pathBytes.length, start >> 3);
        return allBytes;
    }

    private static long hash1(byte[] bytes) {
        int PRIME = 104729;
        return Murmur3.hash64(bytes, 0, bytes.length, 104729);
    }

    private static long hash2(byte[] bytes) {
        int PRIME = 1366661;
        return Murmur3.hash64(bytes, 0, bytes.length, 1366661);
    }
}

