/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorColumnMapping;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorCopyRow {
    protected static final transient Logger LOG = LoggerFactory.getLogger(VectorCopyRow.class);
    private CopyRow[] subRowToBatchCopiersByValue;
    private CopyRow[] subRowToBatchCopiersByReference;

    public void init(VectorColumnMapping columnMapping) throws HiveException {
        int count = columnMapping.getCount();
        this.subRowToBatchCopiersByValue = new CopyRow[count];
        this.subRowToBatchCopiersByReference = new CopyRow[count];
        for (int i = 0; i < count; ++i) {
            int inputColumn = columnMapping.getInputColumns()[i];
            int outputColumn = columnMapping.getOutputColumns()[i];
            TypeInfo typeInfo = columnMapping.getTypeInfos()[i];
            ColumnVector.Type columnVectorType = VectorizationContext.getColumnVectorTypeFromTypeInfo(typeInfo);
            CopyRow copyRowByValue = null;
            BytesCopyRowByReference copyRowByReference = null;
            switch (columnVectorType) {
                case LONG: {
                    copyRowByValue = new LongCopyRow(inputColumn, outputColumn);
                    break;
                }
                case TIMESTAMP: {
                    copyRowByValue = new TimestampCopyRow(inputColumn, outputColumn);
                    break;
                }
                case INTERVAL_DAY_TIME: {
                    copyRowByValue = new IntervalDayTimeCopyRow(inputColumn, outputColumn);
                    break;
                }
                case DOUBLE: {
                    copyRowByValue = new DoubleCopyRow(inputColumn, outputColumn);
                    break;
                }
                case BYTES: {
                    copyRowByValue = new BytesCopyRowByValue(inputColumn, outputColumn);
                    copyRowByReference = new BytesCopyRowByReference(inputColumn, outputColumn);
                    break;
                }
                case DECIMAL: {
                    copyRowByValue = new DecimalCopyRow(inputColumn, outputColumn);
                    break;
                }
                default: {
                    throw new HiveException("Unexpected column vector type " + (Object)((Object)columnVectorType));
                }
            }
            this.subRowToBatchCopiersByValue[i] = copyRowByValue;
            this.subRowToBatchCopiersByReference[i] = copyRowByReference == null ? copyRowByValue : copyRowByReference;
        }
    }

    public void copyByValue(VectorizedRowBatch inBatch, int inBatchIndex, VectorizedRowBatch outBatch, int outBatchIndex) {
        for (CopyRow copyRow : this.subRowToBatchCopiersByValue) {
            copyRow.copy(inBatch, inBatchIndex, outBatch, outBatchIndex);
        }
    }

    public void copyByReference(VectorizedRowBatch inBatch, int inBatchIndex, VectorizedRowBatch outBatch, int outBatchIndex) {
        for (CopyRow copyRow : this.subRowToBatchCopiersByReference) {
            copyRow.copy(inBatch, inBatchIndex, outBatch, outBatchIndex);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("VectorCopyRow ");
        for (CopyRow copyRow : this.subRowToBatchCopiersByValue) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(copyRow.getClass().getName());
            sb.append(" inColumnIndex " + copyRow.inColumnIndex);
            sb.append(" outColumnIndex " + copyRow.outColumnIndex);
        }
        return sb.toString();
    }

    private class IntervalDayTimeCopyRow
    extends CopyRow {
        IntervalDayTimeCopyRow(int inColumnIndex, int outColumnIndex) {
            super(inColumnIndex, outColumnIndex);
        }

        @Override
        void copy(VectorizedRowBatch inBatch, int inBatchIndex, VectorizedRowBatch outBatch, int outBatchIndex) {
            IntervalDayTimeColumnVector inColVector = (IntervalDayTimeColumnVector)inBatch.cols[this.inColumnIndex];
            IntervalDayTimeColumnVector outColVector = (IntervalDayTimeColumnVector)outBatch.cols[this.outColumnIndex];
            if (inColVector.isRepeating) {
                if (inColVector.noNulls || !inColVector.isNull[0]) {
                    outColVector.setElement(outBatchIndex, 0, inColVector);
                } else {
                    VectorizedBatchUtil.setNullColIsNullValue(outColVector, outBatchIndex);
                }
            } else if (inColVector.noNulls || !inColVector.isNull[inBatchIndex]) {
                outColVector.setElement(outBatchIndex, inBatchIndex, inColVector);
            } else {
                VectorizedBatchUtil.setNullColIsNullValue(outColVector, outBatchIndex);
            }
        }
    }

    private class TimestampCopyRow
    extends CopyRow {
        TimestampCopyRow(int inColumnIndex, int outColumnIndex) {
            super(inColumnIndex, outColumnIndex);
        }

        @Override
        void copy(VectorizedRowBatch inBatch, int inBatchIndex, VectorizedRowBatch outBatch, int outBatchIndex) {
            TimestampColumnVector inColVector = (TimestampColumnVector)inBatch.cols[this.inColumnIndex];
            TimestampColumnVector outColVector = (TimestampColumnVector)outBatch.cols[this.outColumnIndex];
            if (inColVector.isRepeating) {
                if (inColVector.noNulls || !inColVector.isNull[0]) {
                    outColVector.setElement(outBatchIndex, 0, inColVector);
                } else {
                    VectorizedBatchUtil.setNullColIsNullValue(outColVector, outBatchIndex);
                }
            } else if (inColVector.noNulls || !inColVector.isNull[inBatchIndex]) {
                outColVector.setElement(outBatchIndex, inBatchIndex, inColVector);
            } else {
                VectorizedBatchUtil.setNullColIsNullValue(outColVector, outBatchIndex);
            }
        }
    }

    private class DecimalCopyRow
    extends CopyRow {
        DecimalCopyRow(int inColumnIndex, int outColumnIndex) {
            super(inColumnIndex, outColumnIndex);
        }

        @Override
        void copy(VectorizedRowBatch inBatch, int inBatchIndex, VectorizedRowBatch outBatch, int outBatchIndex) {
            DecimalColumnVector inColVector = (DecimalColumnVector)inBatch.cols[this.inColumnIndex];
            DecimalColumnVector outColVector = (DecimalColumnVector)outBatch.cols[this.outColumnIndex];
            if (inColVector.isRepeating) {
                if (inColVector.noNulls || !inColVector.isNull[0]) {
                    outColVector.isNull[outBatchIndex] = false;
                    outColVector.set(outBatchIndex, inColVector.vector[0]);
                } else {
                    VectorizedBatchUtil.setNullColIsNullValue(outColVector, outBatchIndex);
                }
            } else if (inColVector.noNulls || !inColVector.isNull[inBatchIndex]) {
                outColVector.isNull[outBatchIndex] = false;
                outColVector.set(outBatchIndex, inColVector.vector[inBatchIndex]);
            } else {
                VectorizedBatchUtil.setNullColIsNullValue(outColVector, outBatchIndex);
            }
        }
    }

    private class BytesCopyRowByReference
    extends AbstractBytesCopyRow {
        BytesCopyRowByReference(int inColumnIndex, int outColumnIndex) {
            super(inColumnIndex, outColumnIndex);
        }

        @Override
        void copy(VectorizedRowBatch inBatch, int inBatchIndex, VectorizedRowBatch outBatch, int outBatchIndex) {
            BytesColumnVector inColVector = (BytesColumnVector)inBatch.cols[this.inColumnIndex];
            BytesColumnVector outColVector = (BytesColumnVector)outBatch.cols[this.outColumnIndex];
            if (inColVector.isRepeating) {
                if (inColVector.noNulls || !inColVector.isNull[0]) {
                    outColVector.setRef(outBatchIndex, inColVector.vector[0], inColVector.start[0], inColVector.length[0]);
                    outColVector.isNull[outBatchIndex] = false;
                } else {
                    VectorizedBatchUtil.setNullColIsNullValue(outColVector, outBatchIndex);
                }
            } else if (inColVector.noNulls || !inColVector.isNull[inBatchIndex]) {
                outColVector.setRef(outBatchIndex, inColVector.vector[inBatchIndex], inColVector.start[inBatchIndex], inColVector.length[inBatchIndex]);
                outColVector.isNull[outBatchIndex] = false;
            } else {
                VectorizedBatchUtil.setNullColIsNullValue(outColVector, outBatchIndex);
            }
        }
    }

    private class BytesCopyRowByValue
    extends AbstractBytesCopyRow {
        BytesCopyRowByValue(int inColumnIndex, int outColumnIndex) {
            super(inColumnIndex, outColumnIndex);
        }

        @Override
        void copy(VectorizedRowBatch inBatch, int inBatchIndex, VectorizedRowBatch outBatch, int outBatchIndex) {
            BytesColumnVector inColVector = (BytesColumnVector)inBatch.cols[this.inColumnIndex];
            BytesColumnVector outColVector = (BytesColumnVector)outBatch.cols[this.outColumnIndex];
            if (inColVector.isRepeating) {
                if (inColVector.noNulls || !inColVector.isNull[0]) {
                    outColVector.setVal(outBatchIndex, inColVector.vector[0], inColVector.start[0], inColVector.length[0]);
                    outColVector.isNull[outBatchIndex] = false;
                } else {
                    VectorizedBatchUtil.setNullColIsNullValue(outColVector, outBatchIndex);
                }
            } else if (inColVector.noNulls || !inColVector.isNull[inBatchIndex]) {
                outColVector.setVal(outBatchIndex, inColVector.vector[inBatchIndex], inColVector.start[inBatchIndex], inColVector.length[inBatchIndex]);
                outColVector.isNull[outBatchIndex] = false;
            } else {
                VectorizedBatchUtil.setNullColIsNullValue(outColVector, outBatchIndex);
            }
        }
    }

    private abstract class AbstractBytesCopyRow
    extends CopyRow {
        AbstractBytesCopyRow(int inColumnIndex, int outColumnIndex) {
            super(inColumnIndex, outColumnIndex);
        }
    }

    private class DoubleCopyRow
    extends CopyRow {
        DoubleCopyRow(int inColumnIndex, int outColumnIndex) {
            super(inColumnIndex, outColumnIndex);
        }

        @Override
        void copy(VectorizedRowBatch inBatch, int inBatchIndex, VectorizedRowBatch outBatch, int outBatchIndex) {
            DoubleColumnVector inColVector = (DoubleColumnVector)inBatch.cols[this.inColumnIndex];
            DoubleColumnVector outColVector = (DoubleColumnVector)outBatch.cols[this.outColumnIndex];
            if (inColVector.isRepeating) {
                if (inColVector.noNulls || !inColVector.isNull[0]) {
                    outColVector.vector[outBatchIndex] = inColVector.vector[0];
                    outColVector.isNull[outBatchIndex] = false;
                } else {
                    VectorizedBatchUtil.setNullColIsNullValue(outColVector, outBatchIndex);
                }
            } else if (inColVector.noNulls || !inColVector.isNull[inBatchIndex]) {
                outColVector.vector[outBatchIndex] = inColVector.vector[inBatchIndex];
                outColVector.isNull[outBatchIndex] = false;
            } else {
                VectorizedBatchUtil.setNullColIsNullValue(outColVector, outBatchIndex);
            }
        }
    }

    private class LongCopyRow
    extends CopyRow {
        LongCopyRow(int inColumnIndex, int outColumnIndex) {
            super(inColumnIndex, outColumnIndex);
        }

        @Override
        void copy(VectorizedRowBatch inBatch, int inBatchIndex, VectorizedRowBatch outBatch, int outBatchIndex) {
            LongColumnVector inColVector = (LongColumnVector)inBatch.cols[this.inColumnIndex];
            LongColumnVector outColVector = (LongColumnVector)outBatch.cols[this.outColumnIndex];
            if (inColVector.isRepeating) {
                if (inColVector.noNulls || !inColVector.isNull[0]) {
                    outColVector.vector[outBatchIndex] = inColVector.vector[0];
                    outColVector.isNull[outBatchIndex] = false;
                } else {
                    VectorizedBatchUtil.setNullColIsNullValue(outColVector, outBatchIndex);
                }
            } else if (inColVector.noNulls || !inColVector.isNull[inBatchIndex]) {
                outColVector.vector[outBatchIndex] = inColVector.vector[inBatchIndex];
                outColVector.isNull[outBatchIndex] = false;
            } else {
                VectorizedBatchUtil.setNullColIsNullValue(outColVector, outBatchIndex);
            }
        }
    }

    private abstract class CopyRow {
        protected int inColumnIndex;
        protected int outColumnIndex;

        CopyRow(int inColumnIndex, int outColumnIndex) {
            this.inColumnIndex = inColumnIndex;
            this.outColumnIndex = outColumnIndex;
        }

        abstract void copy(VectorizedRowBatch var1, int var2, VectorizedRowBatch var3, int var4);
    }
}

