/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.plan.ColStatistics;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hive.com.google.common.collect.Lists;
import org.apache.hive.com.google.common.collect.Maps;

public class Statistics
implements Serializable {
    private long numRows;
    private long runTimeNumRows;
    private long dataSize;
    private State basicStatsState;
    private Map<String, ColStatistics> columnStats;
    private State columnStatsState;

    public Statistics() {
        this(0L, 0L, -1L);
    }

    public Statistics(long nr, long ds, long rnr) {
        this.setNumRows(nr);
        this.setDataSize(ds);
        this.setRunTimeNumRows(rnr);
        this.basicStatsState = State.NONE;
        this.columnStats = null;
        this.columnStatsState = State.NONE;
    }

    public long getNumRows() {
        return this.numRows;
    }

    public void setNumRows(long numRows) {
        this.numRows = numRows;
        this.updateBasicStatsState();
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public void setDataSize(long dataSize) {
        this.dataSize = dataSize;
        this.updateBasicStatsState();
    }

    private void updateBasicStatsState() {
        this.basicStatsState = this.numRows <= 0L && this.dataSize <= 0L ? State.NONE : (this.numRows <= 0L || this.dataSize <= 0L ? State.PARTIAL : State.COMPLETE);
    }

    public State getBasicStatsState() {
        return this.basicStatsState;
    }

    public void setBasicStatsState(State basicStatsState) {
        this.basicStatsState = basicStatsState;
    }

    public State getColumnStatsState() {
        return this.columnStatsState;
    }

    public void setColumnStatsState(State columnStatsState) {
        this.columnStatsState = columnStatsState;
    }

    @Explain(displayName="Statistics")
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Num rows: ");
        sb.append(this.numRows);
        if (this.runTimeNumRows >= 0L) {
            sb.append("/" + this.runTimeNumRows);
        }
        sb.append(" Data size: ");
        sb.append(this.dataSize);
        sb.append(" Basic stats: ");
        sb.append((Object)this.basicStatsState);
        sb.append(" Column stats: ");
        sb.append((Object)this.columnStatsState);
        return sb.toString();
    }

    @Explain(displayName="Statistics", explainLevels={Explain.Level.USER})
    public String toUserLevelExplainString() {
        StringBuilder sb = new StringBuilder();
        sb.append("rows=");
        sb.append(this.numRows);
        if (this.runTimeNumRows >= 0L) {
            sb.append("/" + this.runTimeNumRows);
        }
        sb.append(" width=");
        if (this.numRows != 0L) {
            sb.append(this.dataSize / this.numRows);
        } else {
            sb.append("-1");
        }
        return sb.toString();
    }

    public String extendedToString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" numRows: ");
        sb.append(this.numRows);
        sb.append(" dataSize: ");
        sb.append(this.dataSize);
        sb.append(" basicStatsState: ");
        sb.append((Object)this.basicStatsState);
        sb.append(" colStatsState: ");
        sb.append((Object)this.columnStatsState);
        sb.append(" colStats: ");
        sb.append(this.columnStats);
        return sb.toString();
    }

    public Statistics clone() throws CloneNotSupportedException {
        Statistics clone = new Statistics(this.numRows, this.dataSize, this.runTimeNumRows);
        clone.setBasicStatsState(this.basicStatsState);
        clone.setColumnStatsState(this.columnStatsState);
        if (this.columnStats != null) {
            HashMap<String, ColStatistics> cloneColStats = Maps.newHashMap();
            for (Map.Entry<String, ColStatistics> entry : this.columnStats.entrySet()) {
                cloneColStats.put(entry.getKey(), entry.getValue().clone());
            }
            clone.setColumnStats(cloneColStats);
        }
        return clone;
    }

    public void addToNumRows(long nr) {
        this.numRows += nr;
        this.updateBasicStatsState();
    }

    public void addToDataSize(long rds) {
        this.dataSize += rds;
        this.updateBasicStatsState();
    }

    public void setColumnStats(Map<String, ColStatistics> colStats) {
        this.columnStats = colStats;
    }

    public void setColumnStats(List<ColStatistics> colStats) {
        this.columnStats = Maps.newHashMap();
        this.addToColumnStats(colStats);
    }

    public void addToColumnStats(List<ColStatistics> colStats) {
        if (this.columnStats == null) {
            this.columnStats = Maps.newHashMap();
        }
        if (colStats != null) {
            for (ColStatistics cs : colStats) {
                ColStatistics updatedCS = null;
                if (cs == null) continue;
                String key = cs.getColumnName();
                if (this.columnStats.containsKey(key) && this.columnStats.get(key) != null) {
                    updatedCS = this.columnStats.get(key);
                    updatedCS.setAvgColLen(Math.max(updatedCS.getAvgColLen(), cs.getAvgColLen()));
                    updatedCS.setNumNulls(updatedCS.getNumNulls() + cs.getNumNulls());
                    updatedCS.setCountDistint(Math.max(updatedCS.getCountDistint(), cs.getCountDistint()));
                    this.columnStats.put(key, updatedCS);
                    continue;
                }
                this.columnStats.put(key, cs);
            }
        }
    }

    public void updateColumnStatsState(State newState) {
        if (newState.equals((Object)State.PARTIAL)) {
            this.columnStatsState = State.PARTIAL;
        }
        if (newState.equals((Object)State.NONE)) {
            this.columnStatsState = this.columnStatsState.equals((Object)State.NONE) ? State.NONE : State.PARTIAL;
        }
        if (newState.equals((Object)State.COMPLETE)) {
            this.columnStatsState = this.columnStatsState.equals((Object)State.PARTIAL) ? State.PARTIAL : State.COMPLETE;
        }
    }

    public long getAvgRowSize() {
        if (this.numRows != 0L) {
            return this.dataSize / this.numRows;
        }
        return this.dataSize;
    }

    public ColStatistics getColumnStatisticsFromColName(String colName) {
        if (this.columnStats == null) {
            return null;
        }
        for (ColStatistics cs : this.columnStats.values()) {
            if (!cs.getColumnName().equalsIgnoreCase(colName)) continue;
            return cs;
        }
        return null;
    }

    public List<ColStatistics> getColumnStats() {
        if (this.columnStats != null) {
            return Lists.newArrayList(this.columnStats.values());
        }
        return null;
    }

    public long getRunTimeNumRows() {
        return this.runTimeNumRows;
    }

    public void setRunTimeNumRows(long runTimeNumRows) {
        this.runTimeNumRows = runTimeNumRows;
    }

    public static enum State {
        COMPLETE,
        PARTIAL,
        NONE;

    }
}

