/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.NDV;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantIntObjectInspector;

@Description(name="grouping", value="_FUNC_(a, b) - Indicates whether a specified column expression in is aggregated or not. Returns 1 for aggregated or 0 for not aggregated. ", extended="a is the grouping id, b is the index we want to extract")
@UDFType(deterministic=true)
@NDV(maxNdv=2L)
public class GenericUDFGrouping
extends GenericUDF {
    private transient IntObjectInspector groupingIdOI;
    private int index = 0;
    private ByteWritable byteWritable = new ByteWritable();

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("grouping() requires 2 argument, got " + arguments.length);
        }
        if (arguments[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "The first argument to grouping() must be primitive");
        }
        PrimitiveObjectInspector arg1OI = (PrimitiveObjectInspector)arguments[0];
        if (arg1OI.getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.INT) {
            throw new UDFArgumentTypeException(0, "The first argument to grouping() must be an integer");
        }
        this.groupingIdOI = (IntObjectInspector)arguments[0];
        PrimitiveObjectInspector arg2OI = (PrimitiveObjectInspector)arguments[1];
        if (!(arg2OI instanceof WritableConstantIntObjectInspector)) {
            throw new UDFArgumentTypeException(1, "The second argument to grouping() must be a constant");
        }
        this.index = ((WritableConstantIntObjectInspector)arg2OI).getWritableConstantValue().get();
        return PrimitiveObjectInspectorFactory.writableByteObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        this.byteWritable.set((byte)(PrimitiveObjectInspectorUtils.getInt(arguments[0].get(), this.groupingIdOI) >> this.index & 1));
        return this.byteWritable;
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length == 2);
        return this.getStandardDisplayString("grouping", children);
    }
}

