/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import org.apache.hadoop.hive.common.type.DataTypePhysicalVariation;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VoidColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class ConstantVectorExpression
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    protected long longValue = 0L;
    private double doubleValue = 0.0;
    private byte[] bytesValue = null;
    private HiveDecimal decimalValue = null;
    private Timestamp timestampValue = null;
    private HiveIntervalDayTime intervalDayTimeValue = null;
    private boolean isNullValue = false;
    private final ColumnVector.Type type;
    private int bytesValueLength = 0;

    public ConstantVectorExpression() {
        this.type = null;
    }

    ConstantVectorExpression(int outputColumnNum, TypeInfo outputTypeInfo) throws HiveException {
        super(outputColumnNum);
        this.outputTypeInfo = outputTypeInfo;
        this.outputDataTypePhysicalVariation = DataTypePhysicalVariation.NONE;
        this.type = VectorizationContext.getColumnVectorTypeFromTypeInfo(outputTypeInfo);
    }

    public ConstantVectorExpression(int outputColumnNum, long value, TypeInfo outputTypeInfo) throws HiveException {
        this(outputColumnNum, outputTypeInfo);
        this.longValue = value;
    }

    public ConstantVectorExpression(int outputColumnNum, double value, TypeInfo outputTypeInfo) throws HiveException {
        this(outputColumnNum, outputTypeInfo);
        this.doubleValue = value;
    }

    public ConstantVectorExpression(int outputColumnNum, byte[] value, TypeInfo outputTypeInfo) throws HiveException {
        this(outputColumnNum, outputTypeInfo);
        this.setBytesValue(value);
    }

    public ConstantVectorExpression(int outputColumnNum, HiveChar value, TypeInfo outputTypeInfo) throws HiveException {
        this(outputColumnNum, outputTypeInfo);
        this.setBytesValue(value.getStrippedValue().getBytes());
    }

    public ConstantVectorExpression(int outputColumnNum, HiveVarchar value, TypeInfo outputTypeInfo) throws HiveException {
        this(outputColumnNum, outputTypeInfo);
        this.setBytesValue(value.getValue().getBytes());
    }

    public ConstantVectorExpression(int outputColumnNum, HiveDecimal value, TypeInfo outputTypeInfo) throws HiveException {
        this(outputColumnNum, outputTypeInfo);
        this.setDecimalValue(value);
    }

    public ConstantVectorExpression(int outputColumnNum, Timestamp value, TypeInfo outputTypeInfo) throws HiveException {
        this(outputColumnNum, outputTypeInfo);
        this.setTimestampValue(value);
    }

    public ConstantVectorExpression(int outputColumnNum, HiveIntervalDayTime value, TypeInfo outputTypeInfo) throws HiveException {
        this(outputColumnNum, outputTypeInfo);
        this.setIntervalDayTimeValue(value);
    }

    public ConstantVectorExpression(int outputColumnNum, TypeInfo outputTypeInfo, boolean isNull) throws HiveException {
        this(outputColumnNum, outputTypeInfo);
        this.isNullValue = isNull;
    }

    private void evaluateLong(VectorizedRowBatch vrg) {
        LongColumnVector cv = (LongColumnVector)vrg.cols[this.outputColumnNum];
        cv.isRepeating = true;
        if (!this.isNullValue) {
            cv.isNull[0] = false;
            cv.vector[0] = this.longValue;
        } else {
            cv.isNull[0] = true;
            cv.noNulls = false;
        }
    }

    private void evaluateDouble(VectorizedRowBatch vrg) {
        DoubleColumnVector cv = (DoubleColumnVector)vrg.cols[this.outputColumnNum];
        cv.isRepeating = true;
        if (!this.isNullValue) {
            cv.isNull[0] = false;
            cv.vector[0] = this.doubleValue;
        } else {
            cv.isNull[0] = true;
            cv.noNulls = false;
        }
    }

    private void evaluateBytes(VectorizedRowBatch vrg) {
        BytesColumnVector cv = (BytesColumnVector)vrg.cols[this.outputColumnNum];
        cv.isRepeating = true;
        cv.initBuffer();
        if (!this.isNullValue) {
            cv.isNull[0] = false;
            cv.setVal(0, this.bytesValue, 0, this.bytesValueLength);
        } else {
            cv.isNull[0] = true;
            cv.noNulls = false;
        }
    }

    private void evaluateDecimal(VectorizedRowBatch vrg) {
        DecimalColumnVector dcv = (DecimalColumnVector)vrg.cols[this.outputColumnNum];
        dcv.isRepeating = true;
        if (!this.isNullValue) {
            dcv.isNull[0] = false;
            dcv.set(0, this.decimalValue);
        } else {
            dcv.isNull[0] = true;
            dcv.noNulls = false;
        }
    }

    private void evaluateTimestamp(VectorizedRowBatch vrg) {
        TimestampColumnVector tcv = (TimestampColumnVector)vrg.cols[this.outputColumnNum];
        tcv.isRepeating = true;
        if (!this.isNullValue) {
            tcv.isNull[0] = false;
            tcv.set(0, this.timestampValue);
        } else {
            tcv.isNull[0] = true;
            tcv.noNulls = false;
        }
    }

    private void evaluateIntervalDayTime(VectorizedRowBatch vrg) {
        IntervalDayTimeColumnVector dcv = (IntervalDayTimeColumnVector)vrg.cols[this.outputColumnNum];
        dcv.isRepeating = true;
        if (!this.isNullValue) {
            dcv.isNull[0] = false;
            dcv.set(0, this.intervalDayTimeValue);
        } else {
            dcv.isNull[0] = true;
            dcv.noNulls = false;
        }
    }

    private void evaluateVoid(VectorizedRowBatch vrg) {
        VoidColumnVector voidColVector = (VoidColumnVector)vrg.cols[this.outputColumnNum];
        voidColVector.isRepeating = true;
        voidColVector.isNull[0] = true;
        voidColVector.noNulls = false;
    }

    @Override
    public void evaluate(VectorizedRowBatch vrg) {
        switch (this.type) {
            case LONG: {
                this.evaluateLong(vrg);
                break;
            }
            case DOUBLE: {
                this.evaluateDouble(vrg);
                break;
            }
            case BYTES: {
                this.evaluateBytes(vrg);
                break;
            }
            case DECIMAL: {
                this.evaluateDecimal(vrg);
                break;
            }
            case TIMESTAMP: {
                this.evaluateTimestamp(vrg);
                break;
            }
            case INTERVAL_DAY_TIME: {
                this.evaluateIntervalDayTime(vrg);
                break;
            }
            case VOID: {
                this.evaluateVoid(vrg);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected column vector type " + (Object)((Object)this.type));
            }
        }
    }

    public long getLongValue() {
        return this.longValue;
    }

    public void setLongValue(long longValue) {
        this.longValue = longValue;
    }

    public double getDoubleValue() {
        return this.doubleValue;
    }

    public void setDoubleValue(double doubleValue) {
        this.doubleValue = doubleValue;
    }

    public byte[] getBytesValue() {
        return this.bytesValue;
    }

    public void setBytesValue(byte[] bytesValue) {
        this.bytesValue = (byte[])bytesValue.clone();
        this.bytesValueLength = bytesValue.length;
    }

    public void setDecimalValue(HiveDecimal decimalValue) {
        this.decimalValue = decimalValue;
    }

    public HiveDecimal getDecimalValue() {
        return this.decimalValue;
    }

    public void setTimestampValue(Timestamp timestampValue) {
        this.timestampValue = timestampValue;
    }

    public Timestamp getTimestampValue() {
        return this.timestampValue;
    }

    public void setIntervalDayTimeValue(HiveIntervalDayTime intervalDayTimeValue) {
        this.intervalDayTimeValue = intervalDayTimeValue;
    }

    public HiveIntervalDayTime getIntervalDayTimeValue() {
        return this.intervalDayTimeValue;
    }

    @Override
    public String vectorExpressionParameters() {
        String value;
        if (this.isNullValue) {
            value = "null";
        } else {
            switch (this.type) {
                case LONG: {
                    value = Long.toString(this.longValue);
                    break;
                }
                case DOUBLE: {
                    value = Double.toString(this.doubleValue);
                    break;
                }
                case BYTES: {
                    value = new String(this.bytesValue, StandardCharsets.UTF_8);
                    break;
                }
                case DECIMAL: {
                    value = this.decimalValue.toString();
                    break;
                }
                case TIMESTAMP: {
                    value = org.apache.hadoop.hive.common.type.Timestamp.ofEpochMilli(this.timestampValue.getTime(), this.timestampValue.getNanos()).toString();
                    break;
                }
                case INTERVAL_DAY_TIME: {
                    value = this.intervalDayTimeValue.toString();
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown vector column type " + (Object)((Object)this.type));
                }
            }
        }
        return "val " + value;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().build();
    }
}

