/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.llap.LlapDaemonInfo;
import org.apache.hadoop.hive.ql.exec.HashTableLoader;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.MemoryMonitorInfo;
import org.apache.hadoop.hive.ql.exec.mapjoin.MapJoinMemoryExhaustionError;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapperContext;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainerSerDe;
import org.apache.hadoop.hive.ql.exec.tez.TezContext;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastTableContainer;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.library.api.KeyValueReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorMapJoinFastHashTableLoader
implements HashTableLoader {
    private static final Logger LOG = LoggerFactory.getLogger((String)VectorMapJoinFastHashTableLoader.class.getName());
    private Configuration hconf;
    protected MapJoinDesc desc;
    private TezContext tezContext;
    private String cacheKey;

    @Override
    public void init(ExecMapperContext context, MapredContext mrContext, Configuration hconf, MapJoinOperator joinOp) {
        this.tezContext = (TezContext)mrContext;
        this.hconf = hconf;
        this.desc = (MapJoinDesc)joinOp.getConf();
        this.cacheKey = joinOp.getCacheKey();
    }

    @Override
    public void load(MapJoinTableContainer[] mapJoinTables, MapJoinTableContainerSerDe[] mapJoinTableSerdes) throws HiveException {
        Map<Integer, String> parentToInput = this.desc.getParentToInput();
        Map<Integer, Long> parentKeyCounts = this.desc.getParentKeyCounts();
        MemoryMonitorInfo memoryMonitorInfo = this.desc.getMemoryMonitorInfo();
        boolean doMemCheck = false;
        long effectiveThreshold = 0L;
        if (memoryMonitorInfo != null) {
            effectiveThreshold = memoryMonitorInfo.getEffectiveThreshold(this.desc.getMaxMemoryAvailable());
            if (!LlapDaemonInfo.INSTANCE.isLlap()) {
                memoryMonitorInfo.setLlap(false);
            }
            if (memoryMonitorInfo.doMemoryMonitoring()) {
                doMemCheck = true;
                if (LOG.isInfoEnabled()) {
                    LOG.info("Memory monitoring for hash table loader enabled. {}", (Object)memoryMonitorInfo);
                }
            }
        }
        if (!doMemCheck && LOG.isInfoEnabled()) {
            LOG.info("Not doing hash table memory monitoring. {}", (Object)memoryMonitorInfo);
        }
        for (int pos = 0; pos < mapJoinTables.length; ++pos) {
            if (pos == this.desc.getPosBigTable()) continue;
            long numEntries = 0L;
            String inputName = parentToInput.get(pos);
            LogicalInput input = this.tezContext.getInput(inputName);
            try {
                input.start();
                this.tezContext.getTezProcessorContext().waitForAnyInputReady(Collections.singletonList(input));
            }
            catch (Exception e) {
                throw new HiveException(e);
            }
            try {
                KeyValueReader kvReader = (KeyValueReader)input.getReader();
                Long keyCountObj = parentKeyCounts.get(pos);
                long keyCount = keyCountObj == null ? -1L : keyCountObj;
                VectorMapJoinFastTableContainer vectorMapJoinFastTableContainer = new VectorMapJoinFastTableContainer(this.desc, this.hconf, keyCount);
                LOG.info("Loading hash table for input: {} cacheKey: {} tableContainer: {} smallTablePos: {}", new Object[]{inputName, this.cacheKey, vectorMapJoinFastTableContainer.getClass().getSimpleName(), pos});
                vectorMapJoinFastTableContainer.setSerde(null, null);
                while (kvReader.next()) {
                    vectorMapJoinFastTableContainer.putRow((Writable)((BytesWritable)kvReader.getCurrentKey()), (Writable)((BytesWritable)kvReader.getCurrentValue()));
                    if (!doMemCheck || ++numEntries % memoryMonitorInfo.getMemoryCheckInterval() != 0L) continue;
                    long estMemUsage = vectorMapJoinFastTableContainer.getEstimatedMemorySize();
                    if (estMemUsage > effectiveThreshold) {
                        String msg = "Hash table loading exceeded memory limits for input: " + inputName + " numEntries: " + numEntries + " estimatedMemoryUsage: " + estMemUsage + " effectiveThreshold: " + effectiveThreshold + " memoryMonitorInfo: " + memoryMonitorInfo;
                        LOG.error(msg);
                        throw new MapJoinMemoryExhaustionError(msg);
                    }
                    if (!LOG.isInfoEnabled()) continue;
                    LOG.info("Checking hash table loader memory usage for input: {} numEntries: {} estimatedMemoryUsage: {} effectiveThreshold: {}", new Object[]{inputName, numEntries, estMemUsage, effectiveThreshold});
                }
                vectorMapJoinFastTableContainer.seal();
                mapJoinTables[pos] = vectorMapJoinFastTableContainer;
                if (doMemCheck) {
                    LOG.info("Finished loading hash table for input: {} cacheKey: {} numEntries: {} estimatedMemoryUsage: {}", new Object[]{inputName, this.cacheKey, numEntries, vectorMapJoinFastTableContainer.getEstimatedMemorySize()});
                    continue;
                }
                LOG.info("Finished loading hash table for input: {} cacheKey: {} numEntries: {}", new Object[]{inputName, this.cacheKey, numEntries});
                continue;
            }
            catch (IOException e) {
                throw new HiveException(e);
            }
            catch (SerDeException e) {
                throw new HiveException(e);
            }
            catch (Exception e) {
                throw new HiveException(e);
            }
        }
    }
}

