/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.NDV;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.Text;

@UDFType(deterministic=false, runtimeConstant=true)
@Description(name="logged_in_user", value="_FUNC_() - Returns logged in user name", extended="SessionState GetUserName - the username provided at session initialization")
@NDV(maxNdv=1L)
public class GenericUDFLoggedInUser
extends GenericUDF {
    protected Text loggedInUser;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        String loggedInUserName;
        if (arguments.length != 0) {
            throw new UDFArgumentLengthException("The function LOGGED_IN_USER does not take any arguments, but found " + arguments.length);
        }
        if (this.loggedInUser == null && (loggedInUserName = SessionState.get().getUserName()) != null) {
            this.loggedInUser = new Text(loggedInUserName);
        }
        return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        return this.loggedInUser;
    }

    public Text getLoggedInUser() {
        return this.loggedInUser;
    }

    public void setLoggedInUser(Text loggedInUser) {
        this.loggedInUser = loggedInUser;
    }

    @Override
    public String getDisplayString(String[] children) {
        return "LOGGED_IN_USER()";
    }

    @Override
    public void copyToNewInstance(Object newInstance) throws UDFArgumentException {
        super.copyToNewInstance(newInstance);
        GenericUDFLoggedInUser other = (GenericUDFLoggedInUser)newInstance;
        if (this.loggedInUser != null) {
            other.loggedInUser = new Text(this.loggedInUser);
        }
    }
}

