/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.orc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hive.orc.ColumnStatistics;
import org.apache.hive.orc.CompressionKind;
import org.apache.hive.orc.DataReader;
import org.apache.hive.orc.OrcFile;
import org.apache.hive.orc.OrcProto;
import org.apache.hive.orc.RecordReader;
import org.apache.hive.orc.StripeInformation;
import org.apache.hive.orc.StripeStatistics;
import org.apache.hive.orc.TypeDescription;

public interface Reader {
    public long getNumberOfRows();

    public long getRawDataSize();

    public long getRawDataSizeOfColumns(List<String> var1);

    public long getRawDataSizeFromColIndices(List<Integer> var1);

    public List<String> getMetadataKeys();

    public ByteBuffer getMetadataValue(String var1);

    public boolean hasMetadataValue(String var1);

    public CompressionKind getCompressionKind();

    public int getCompressionSize();

    public int getRowIndexStride();

    public List<StripeInformation> getStripes();

    public long getContentLength();

    public ColumnStatistics[] getStatistics();

    public TypeDescription getSchema();

    public List<OrcProto.Type> getTypes();

    public OrcFile.Version getFileVersion();

    public OrcFile.WriterVersion getWriterVersion();

    public OrcProto.FileTail getFileTail();

    public RecordReader rows() throws IOException;

    public RecordReader rows(Options var1) throws IOException;

    public List<Integer> getVersionList();

    public int getMetadataSize();

    public List<OrcProto.StripeStatistics> getOrcProtoStripeStatistics();

    public List<StripeStatistics> getStripeStatistics() throws IOException;

    public List<OrcProto.ColumnStatistics> getOrcProtoFileStatistics();

    public ByteBuffer getSerializedFileFooter();

    public static class Options {
        private boolean[] include;
        private long offset = 0L;
        private long length = Long.MAX_VALUE;
        private SearchArgument sarg = null;
        private String[] columnNames = null;
        private Boolean useZeroCopy = null;
        private Boolean skipCorruptRecords = null;
        private TypeDescription schema = null;
        private DataReader dataReader = null;

        public Options include(boolean[] include) {
            this.include = include;
            return this;
        }

        public Options range(long offset, long length) {
            this.offset = offset;
            this.length = length;
            return this;
        }

        public Options schema(TypeDescription schema) {
            this.schema = schema;
            return this;
        }

        public Options searchArgument(SearchArgument sarg, String[] columnNames) {
            this.sarg = sarg;
            this.columnNames = columnNames;
            return this;
        }

        public Options useZeroCopy(boolean value) {
            this.useZeroCopy = value;
            return this;
        }

        public Options dataReader(DataReader value) {
            this.dataReader = value;
            return this;
        }

        public Options skipCorruptRecords(boolean value) {
            this.skipCorruptRecords = value;
            return this;
        }

        public boolean[] getInclude() {
            return this.include;
        }

        public long getOffset() {
            return this.offset;
        }

        public long getLength() {
            return this.length;
        }

        public TypeDescription getSchema() {
            return this.schema;
        }

        public SearchArgument getSearchArgument() {
            return this.sarg;
        }

        public String[] getColumnNames() {
            return this.columnNames;
        }

        public long getMaxOffset() {
            long result = this.offset + this.length;
            if (result < 0L) {
                result = Long.MAX_VALUE;
            }
            return result;
        }

        public Boolean getUseZeroCopy() {
            return this.useZeroCopy;
        }

        public Boolean getSkipCorruptRecords() {
            return this.skipCorruptRecords;
        }

        public DataReader getDataReader() {
            return this.dataReader;
        }

        public Options clone() {
            Options result = new Options();
            result.include = this.include;
            result.offset = this.offset;
            result.length = this.length;
            result.sarg = this.sarg;
            result.schema = this.schema;
            result.columnNames = this.columnNames;
            result.useZeroCopy = this.useZeroCopy;
            result.skipCorruptRecords = this.skipCorruptRecords;
            result.dataReader = this.dataReader == null ? null : this.dataReader.clone();
            return result;
        }

        public String toString() {
            int i;
            StringBuilder buffer = new StringBuilder();
            buffer.append("{include: ");
            if (this.include == null) {
                buffer.append("null");
            } else {
                buffer.append("[");
                for (i = 0; i < this.include.length; ++i) {
                    if (i != 0) {
                        buffer.append(", ");
                    }
                    buffer.append(this.include[i]);
                }
                buffer.append("]");
            }
            buffer.append(", offset: ");
            buffer.append(this.offset);
            buffer.append(", length: ");
            buffer.append(this.length);
            if (this.sarg != null) {
                buffer.append(", sarg: ");
                buffer.append(this.sarg.toString());
                buffer.append(", columns: [");
                for (i = 0; i < this.columnNames.length; ++i) {
                    if (i != 0) {
                        buffer.append(", ");
                    }
                    buffer.append("'");
                    buffer.append(this.columnNames[i]);
                    buffer.append("'");
                }
                buffer.append("]");
            }
            if (this.schema != null) {
                buffer.append(", schema: ");
                this.schema.printToBuffer(buffer);
            }
            buffer.append("}");
            return buffer.toString();
        }
    }
}

