/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.orc.impl;

import java.io.EOFException;
import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hive.orc.impl.InStream;
import org.apache.hive.orc.impl.PositionProvider;
import org.apache.hive.orc.impl.RunLengthByteReader;

public class BitFieldReader {
    private final RunLengthByteReader input;
    private final int bitSize;
    private int current;
    private int bitsLeft;
    private final int mask;
    private boolean lastRunValue;
    private int lastRunLength = -1;

    public BitFieldReader(InStream input, int bitSize) throws IOException {
        this.input = new RunLengthByteReader(input);
        this.bitSize = bitSize;
        this.mask = (1 << bitSize) - 1;
    }

    public void setInStream(InStream inStream) {
        this.input.setInStream(inStream);
    }

    private void readByte() throws IOException {
        if (!this.input.hasNext()) {
            throw new EOFException("Read past end of bit field from " + this);
        }
        this.current = 0xFF & this.input.next();
        this.bitsLeft = 8;
    }

    public int next() throws IOException {
        int bitsLeftToRead;
        int result = 0;
        for (bitsLeftToRead = this.bitSize; bitsLeftToRead > this.bitsLeft; bitsLeftToRead -= this.bitsLeft) {
            result <<= this.bitsLeft;
            result |= this.current & (1 << this.bitsLeft) - 1;
            this.readByte();
        }
        if (bitsLeftToRead > 0) {
            result <<= bitsLeftToRead;
            this.bitsLeft -= bitsLeftToRead;
            result |= this.current >>> this.bitsLeft & (1 << bitsLeftToRead) - 1;
        }
        return result & this.mask;
    }

    private void readNextRun(int maxRunLength) throws IOException {
        assert (this.bitSize == 1);
        if (this.lastRunLength > 0) {
            return;
        }
        if (this.bitsLeft == 0) {
            this.readByte();
        }
        boolean hasVal = false;
        int runLength = 0;
        if (this.bitsLeft != 8) {
            int partialBitsMask = (1 << this.bitsLeft) - 1;
            int partialBits = this.current & partialBitsMask;
            if (partialBits == partialBitsMask || partialBits == 0) {
                boolean bl = this.lastRunValue = partialBits == partialBitsMask;
                if (maxRunLength <= this.bitsLeft) {
                    this.lastRunLength = maxRunLength;
                    return;
                }
                maxRunLength -= this.bitsLeft;
            } else {
                int prefixBitsCount = 32 - this.bitsLeft;
                runLength = Integer.numberOfLeadingZeros(partialBits) - prefixBitsCount;
                this.lastRunValue = runLength > 0;
                this.lastRunLength = Math.min(maxRunLength, this.lastRunValue ? runLength : Integer.numberOfLeadingZeros(~(partialBits | ~partialBitsMask)) - prefixBitsCount);
                return;
            }
            hasVal = true;
            runLength = this.bitsLeft;
            this.bitsLeft = 0;
            assert (this.bitsLeft == 0);
            this.readByte();
        }
        if (!hasVal) {
            this.lastRunValue = this.current >> 7 == 1;
            hasVal = true;
        }
        assert (this.bitsLeft == 8);
        while (maxRunLength >= 8 && (this.lastRunValue && this.current == 255 || !this.lastRunValue && this.current == 0)) {
            runLength += 8;
            maxRunLength -= 8;
            this.readByte();
        }
        if (maxRunLength > 0) {
            int extraBits = Integer.numberOfLeadingZeros(this.lastRunValue ? ~(this.current | 0xFFFFFF00) : this.current) - 24;
            this.bitsLeft -= extraBits;
            runLength += extraBits;
        }
        this.lastRunLength = runLength;
    }

    public void nextVector(LongColumnVector previous, long previousLen) throws IOException {
        previous.isRepeating = true;
        int i = 0;
        while ((long)i < previousLen) {
            previous.vector[i] = previous.noNulls || !previous.isNull[i] ? (long)this.next() : 1L;
            if (previous.isRepeating && i > 0 && (previous.vector[0] != previous.vector[i] || previous.isNull[0] != previous.isNull[i])) {
                previous.isRepeating = false;
            }
            ++i;
        }
    }

    public void seek(PositionProvider index) throws IOException {
        this.input.seek(index);
        int consumed = (int)index.getNext();
        if (consumed > 8) {
            throw new IllegalArgumentException("Seek past end of byte at " + consumed + " in " + this.input);
        }
        if (consumed != 0) {
            this.readByte();
            this.bitsLeft = 8 - consumed;
        } else {
            this.bitsLeft = 0;
        }
    }

    public void skip(long items) throws IOException {
        long totalBits = (long)this.bitSize * items;
        if ((long)this.bitsLeft >= totalBits) {
            this.bitsLeft = (int)((long)this.bitsLeft - totalBits);
        } else {
            this.input.skip((totalBits -= (long)this.bitsLeft) / 8L);
            this.current = this.input.next();
            this.bitsLeft = (int)(8L - totalBits % 8L);
        }
    }

    public String toString() {
        return "bit reader current: " + this.current + " bits left: " + this.bitsLeft + " bit size: " + this.bitSize + " from " + this.input;
    }

    boolean hasFullByte() {
        return this.bitsLeft == 8 || this.bitsLeft == 0;
    }

    int peekOneBit() throws IOException {
        assert (this.bitSize == 1);
        if (this.bitsLeft == 0) {
            this.readByte();
        }
        return this.current >>> this.bitsLeft - 1 & 1;
    }

    int peekFullByte() throws IOException {
        assert (this.bitSize == 1);
        assert (this.bitsLeft == 8 || this.bitsLeft == 0);
        if (this.bitsLeft == 0) {
            this.readByte();
        }
        return this.current;
    }

    void skipInCurrentByte(int bits) throws IOException {
        assert (this.bitsLeft >= bits);
        this.bitsLeft -= bits;
    }
}

