/*
 * $HeadURL: http://svn.apache.org/repos/asf/httpcomponents/httpclient/trunk/httpclient/src/main/java/org/apache/http/auth/AuthSchemeFactory.java $
 * $Revision: 775317 $
 * $Date: 2009-05-15 20:32:30 +0000 (Fri, 15 May 2009) $
 *
 * ====================================================================
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 */

package org.apache.http.auth;

import org.apache.http.params.HttpParams;

/**
 * Factory for {@link AuthScheme} implementations. 
 *
 * @since 4.0
 */
public interface AuthSchemeFactory {    

	/**
	 * Creates an instance of {@link AuthScheme} using given HTTP parameters.
	 * 
	 * @param params HTTP parameters.
	 * 
	 * @return auth scheme.
	 */
    AuthScheme newInstance(HttpParams params);

}
