/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.integration;

import java.io.IOException;
import java.net.Socket;
import org.apache.http.HttpConnectionFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.DefaultBHttpServerConnection;
import org.apache.http.localserver.LocalServerTestBase;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestMalformedServerResponse
extends LocalServerTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoContentResponseWithGarbage() throws Exception {
        this.serverBootstrap.setConnectionFactory((HttpConnectionFactory)new BrokenServerConnectionFactory());
        this.serverBootstrap.registerHandler("/nostuff", new HttpRequestHandler(){

            public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
                response.setStatusCode(204);
            }
        });
        this.serverBootstrap.registerHandler("/stuff", new HttpRequestHandler(){

            public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
                response.setStatusCode(200);
                response.setEntity((HttpEntity)new StringEntity("Some important stuff"));
            }
        });
        HttpHost target = this.start();
        HttpGet get1 = new HttpGet("/nostuff");
        CloseableHttpResponse response1 = this.httpclient.execute(target, (HttpRequest)get1);
        try {
            Assert.assertEquals((long)204L, (long)response1.getStatusLine().getStatusCode());
            EntityUtils.consume((HttpEntity)response1.getEntity());
        }
        finally {
            response1.close();
        }
        HttpGet get2 = new HttpGet("/stuff");
        CloseableHttpResponse response2 = this.httpclient.execute(target, (HttpRequest)get2);
        try {
            Assert.assertEquals((long)200L, (long)response2.getStatusLine().getStatusCode());
            EntityUtils.consume((HttpEntity)response2.getEntity());
        }
        finally {
            response2.close();
        }
    }

    static class BrokenServerConnectionFactory
    implements HttpConnectionFactory<DefaultBHttpServerConnection> {
        BrokenServerConnectionFactory() {
        }

        public DefaultBHttpServerConnection createConnection(Socket socket) throws IOException {
            BrokenServerConnection conn = new BrokenServerConnection(4096);
            conn.bind(socket);
            return conn;
        }
    }

    static class BrokenServerConnection
    extends DefaultBHttpServerConnection {
        public BrokenServerConnection(int bufferSize) {
            super(bufferSize);
        }

        public void sendResponseHeader(HttpResponse response) throws HttpException, IOException {
            super.sendResponseHeader(response);
            if (response.getStatusLine().getStatusCode() == 204) {
                response.setEntity((HttpEntity)new StringEntity("garbage\ngarbage\ngarbage\ngarbage\ngarbage\ngarbage\ngarbage\ngarbage\ngarbage\ngarbage\ngarbage\ngarbage\ngarbage\ngarbage\ngarbage\ngarbage\ngarbage\ngarbage\n"));
                this.sendResponseEntity(response);
            }
        }
    }
}

