/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.result;

import com.ibatis.common.resources.Resources;
import com.ibatis.sqlmap.engine.mapping.result.ResultObjectFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ResultObjectFactoryUtil {
    private static ThreadLocal factorySettings = new ThreadLocal();

    private ResultObjectFactoryUtil() {
    }

    public static Object createObjectThroughFactory(Class clazz) throws InstantiationException, IllegalAccessException {
        Object obj;
        FactorySettings fs = ResultObjectFactoryUtil.getFactorySettings();
        if (fs.getResultObjectFactory() == null) {
            obj = ResultObjectFactoryUtil.createObjectInternally(clazz);
        } else {
            obj = fs.getResultObjectFactory().createInstance(fs.getStatementId(), clazz);
            if (obj == null) {
                obj = ResultObjectFactoryUtil.createObjectInternally(clazz);
            }
        }
        return obj;
    }

    private static Object createObjectInternally(Class clazz) throws InstantiationException, IllegalAccessException {
        Class classToCreate = clazz == List.class || clazz == Collection.class ? ArrayList.class : (clazz == Set.class ? HashSet.class : clazz);
        Object obj = Resources.instantiate(classToCreate);
        return obj;
    }

    public static void setResultObjectFactory(ResultObjectFactory resultObjectFactory) {
        ResultObjectFactoryUtil.getFactorySettings().setResultObjectFactory(resultObjectFactory);
    }

    public static void setStatementId(String statementId) {
        ResultObjectFactoryUtil.getFactorySettings().setStatementId(statementId);
    }

    private static FactorySettings getFactorySettings() {
        FactorySettings fs = (FactorySettings)factorySettings.get();
        if (fs == null) {
            fs = new FactorySettings();
            factorySettings.set(fs);
        }
        return fs;
    }

    private static class FactorySettings {
        private ResultObjectFactory resultObjectFactory;
        private String statementId;

        private FactorySettings() {
        }

        public ResultObjectFactory getResultObjectFactory() {
            return this.resultObjectFactory;
        }

        public void setResultObjectFactory(ResultObjectFactory resultObjectFactory) {
            this.resultObjectFactory = resultObjectFactory;
        }

        public String getStatementId() {
            return this.statementId;
        }

        public void setStatementId(String statementId) {
            this.statementId = statementId;
        }
    }
}

