/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.aws.ext;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static final Logger LOG = LoggerFactory.getLogger(Utils.class);
    public static final String DEFAULT_CONFIG_FILE = "aws.properties";
    private static final String DELETE_CONFIG_SUFFIX = ";burn";

    private Utils() {
    }

    public static AmazonS3Client openService(Properties prop) {
        BasicAWSCredentials credentials = new BasicAWSCredentials(prop.getProperty("accessKey"), prop.getProperty("secretKey"));
        int connectionTimeOut = Integer.parseInt(prop.getProperty("connectionTimeout"));
        int socketTimeOut = Integer.parseInt(prop.getProperty("socketTimeout"));
        int maxConnections = Integer.parseInt(prop.getProperty("maxConnections"));
        int maxErrorRetry = Integer.parseInt(prop.getProperty("maxErrorRetry"));
        ClientConfiguration cc = new ClientConfiguration();
        cc.setConnectionTimeout(connectionTimeOut);
        cc.setSocketTimeout(socketTimeOut);
        cc.setMaxConnections(maxConnections);
        cc.setMaxErrorRetry(maxErrorRetry);
        return new AmazonS3Client((AWSCredentials)credentials, cc);
    }

    public static void deleteBucket(String bucketName) throws IOException {
        Properties prop = Utils.readConfig(DEFAULT_CONFIG_FILE);
        AmazonS3Client s3service = Utils.openService(prop);
        ObjectListing prevObjectListing = s3service.listObjects(bucketName);
        while (true) {
            for (S3ObjectSummary s3ObjSumm : prevObjectListing.getObjectSummaries()) {
                s3service.deleteObject(bucketName, s3ObjSumm.getKey());
            }
            if (!prevObjectListing.isTruncated()) break;
            prevObjectListing = s3service.listNextBatchOfObjects(prevObjectListing);
        }
        s3service.deleteBucket(bucketName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readConfig(String fileName) throws IOException {
        boolean delete = false;
        if (fileName.endsWith(DELETE_CONFIG_SUFFIX)) {
            delete = true;
            fileName = fileName.substring(0, fileName.length() - DELETE_CONFIG_SUFFIX.length());
        }
        if (!new File(fileName).exists()) {
            throw new IOException("Config file not found: " + fileName);
        }
        Properties prop = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(fileName);
            prop.load(in);
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
            if (delete) {
                Utils.deleteIfPossible(new File(fileName));
            }
        }
        return prop;
    }

    private static void deleteIfPossible(File file) {
        boolean deleted = file.delete();
        if (!deleted) {
            LOG.warn("Could not delete " + file.getAbsolutePath());
        }
    }
}

