/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jca;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.commons.JcrUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JCARepositoryManager {
    public static final String CLASSPATH_CONFIG_PREFIX = "classpath:";
    private static final JCARepositoryManager INSTANCE = new JCARepositoryManager();
    private final Map<Map<String, String>, Repository> repositories = new HashMap<Map<String, String>, Repository>();
    private boolean autoShutdown = true;

    private JCARepositoryManager() {
    }

    public synchronized Repository createRepository(Map<String, String> parameters) throws RepositoryException {
        Repository repository = this.repositories.get(parameters);
        if (repository == null) {
            repository = JcrUtils.getRepository(parameters);
            this.repositories.put(parameters, repository);
        }
        return repository;
    }

    public synchronized void shutdown() {
        for (Repository repository : this.repositories.values()) {
            if (!(repository instanceof JackrabbitRepository)) continue;
            ((JackrabbitRepository)repository).shutdown();
        }
        this.repositories.clear();
    }

    public static JCARepositoryManager getInstance() {
        return INSTANCE;
    }

    public boolean isAutoShutdown() {
        return this.autoShutdown;
    }

    public void setAutoShutdown(boolean autoShutdown) {
        this.autoShutdown = autoShutdown;
    }

    public synchronized void autoShutdownRepository(Map<String, String> parameters) {
        Repository repository;
        if (this.isAutoShutdown() && (repository = this.repositories.get(parameters)) instanceof JackrabbitRepository) {
            ((JackrabbitRepository)repository).shutdown();
        }
    }
}

