/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.client;

import java.rmi.RemoteException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.jackrabbit.rmi.remote.RemoteXAResource;

public class ClientXAResource
implements XAResource {
    private RemoteXAResource remote;

    public boolean isSameRM(XAResource xares) throws XAException {
        return xares instanceof ClientXAResource && this.remote == ((ClientXAResource)xares).remote;
    }

    public ClientXAResource(RemoteXAResource remote) {
        this.remote = remote;
    }

    private XAException getXAException(RemoteException e) {
        XAException exception = new XAException("Remote operation failed");
        exception.initCause(e);
        return exception;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            this.remote.commit(xid, onePhase);
        }
        catch (RemoteException e) {
            throw this.getXAException(e);
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        try {
            this.remote.end(xid, flags);
        }
        catch (RemoteException e) {
            throw this.getXAException(e);
        }
    }

    public void forget(Xid xid) throws XAException {
        try {
            this.remote.forget(xid);
        }
        catch (RemoteException e) {
            throw this.getXAException(e);
        }
    }

    public int getTransactionTimeout() throws XAException {
        try {
            return this.remote.getTransactionTimeout();
        }
        catch (RemoteException e) {
            throw this.getXAException(e);
        }
    }

    public int prepare(Xid xid) throws XAException {
        try {
            return this.remote.prepare(xid);
        }
        catch (RemoteException e) {
            throw this.getXAException(e);
        }
    }

    public Xid[] recover(int flag) throws XAException {
        try {
            return this.remote.recover(flag);
        }
        catch (RemoteException e) {
            throw this.getXAException(e);
        }
    }

    public void rollback(Xid xid) throws XAException {
        try {
            this.remote.rollback(xid);
        }
        catch (RemoteException e) {
            throw this.getXAException(e);
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        try {
            return this.remote.setTransactionTimeout(seconds);
        }
        catch (RemoteException e) {
            throw this.getXAException(e);
        }
    }

    public void start(Xid xid, int flags) throws XAException {
        try {
            this.remote.start(xid, flags);
        }
        catch (RemoteException e) {
            throw this.getXAException(e);
        }
    }
}

