/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.server.principal;

import java.rmi.RemoteException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.jackrabbit.api.security.principal.GroupPrincipal;
import org.apache.jackrabbit.rmi.remote.RemoteIterator;
import org.apache.jackrabbit.rmi.remote.principal.RemoteGroup;
import org.apache.jackrabbit.rmi.server.RemoteAdapterFactory;
import org.apache.jackrabbit.rmi.server.principal.ServerPrincipal;

public class ServerGroup
extends ServerPrincipal
implements RemoteGroup {
    public ServerGroup(Group principal, RemoteAdapterFactory factory) throws RemoteException {
        super((Principal)principal, factory);
    }

    public ServerGroup(Principal principal, RemoteAdapterFactory factory) throws RemoteException {
        super(principal, factory);
    }

    @Override
    public boolean isMember(String member) {
        return ServerGroup.isMember(member, this.getPrincipal());
    }

    @Override
    public RemoteIterator members() throws RemoteException {
        Iterator<Principal> members = new Iterator<Principal>(){
            final Enumeration<? extends Principal> base;
            {
                this.base = ServerGroup.members(ServerGroup.this.getPrincipal());
            }

            @Override
            public boolean hasNext() {
                return this.base.hasMoreElements();
            }

            @Override
            public Principal next() {
                return this.base.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
        return this.getFactory().getRemotePrincipalIterator(members);
    }

    private static boolean isMember(String memberName, Principal group) {
        Enumeration<? extends Principal> pe = ServerGroup.members(group);
        while (pe.hasMoreElements()) {
            Principal p = pe.nextElement();
            if (memberName.equals(p.getName())) {
                return true;
            }
            if (!ServerGroup.isGroup(p) || !ServerGroup.isMember(memberName, p)) continue;
            return true;
        }
        return false;
    }

    public static boolean isGroup(Principal principal) {
        return principal instanceof Group || principal instanceof GroupPrincipal;
    }

    private static Enumeration<? extends Principal> members(Principal principal) {
        if (principal instanceof Group) {
            return ((Group)principal).members();
        }
        if (principal instanceof GroupPrincipal) {
            return ((GroupPrincipal)principal).members();
        }
        return Collections.emptyEnumeration();
    }
}

