/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.client;

import java.rmi.RemoteException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.qom.QueryObjectModelFactory;
import org.apache.jackrabbit.rmi.client.ClientObject;
import org.apache.jackrabbit.rmi.client.LocalAdapterFactory;
import org.apache.jackrabbit.rmi.client.RemoteRepositoryException;
import org.apache.jackrabbit.rmi.client.RemoteRuntimeException;
import org.apache.jackrabbit.rmi.remote.RemoteQuery;
import org.apache.jackrabbit.rmi.remote.RemoteQueryManager;

public class ClientQueryManager
extends ClientObject
implements QueryManager {
    private Session session;
    private RemoteQueryManager remote;

    public ClientQueryManager(Session session, RemoteQueryManager remote, LocalAdapterFactory factory) {
        super(factory);
        this.session = session;
        this.remote = remote;
    }

    public Query createQuery(String statement, String language) throws RepositoryException {
        try {
            RemoteQuery query = this.remote.createQuery(statement, language);
            return this.getFactory().getQuery(this.session, query);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public Query getQuery(Node node) throws RepositoryException {
        try {
            RemoteQuery query = this.remote.getQuery(node.getPath());
            return this.getFactory().getQuery(this.session, query);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public String[] getSupportedQueryLanguages() throws RepositoryException {
        try {
            return this.remote.getSupportedQueryLanguages();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public QueryObjectModelFactory getQOMFactory() {
        throw new RuntimeException("TODO: JCR-3206");
    }
}

