/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.lock.LockManager;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.observation.ObservationManager;
import javax.jcr.query.QueryManager;
import javax.jcr.version.Version;
import javax.jcr.version.VersionManager;
import org.apache.jackrabbit.rmi.client.ClientObject;
import org.apache.jackrabbit.rmi.client.DefaultContentHandler;
import org.apache.jackrabbit.rmi.client.LocalAdapterFactory;
import org.apache.jackrabbit.rmi.client.RemoteRepositoryException;
import org.apache.jackrabbit.rmi.client.RemoteRuntimeException;
import org.apache.jackrabbit.rmi.client.SerializingContentHandler;
import org.apache.jackrabbit.rmi.remote.RemoteNamespaceRegistry;
import org.apache.jackrabbit.rmi.remote.RemoteNodeTypeManager;
import org.apache.jackrabbit.rmi.remote.RemoteQueryManager;
import org.apache.jackrabbit.rmi.remote.RemoteWorkspace;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ClientWorkspace
extends ClientObject
implements Workspace {
    private Session session;
    private RemoteWorkspace remote;
    private ObservationManager observationManager;
    private LockManager lockManager;
    private VersionManager versionManager;

    public ClientWorkspace(Session session, RemoteWorkspace remote, LocalAdapterFactory factory) {
        super(factory);
        this.session = session;
        this.remote = remote;
    }

    public Session getSession() {
        return this.session;
    }

    public String getName() {
        try {
            return this.remote.getName();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public void copy(String from, String to) throws RepositoryException {
        try {
            this.remote.copy(from, to);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public void copy(String workspace, String from, String to) throws RepositoryException {
        try {
            this.remote.copy(workspace, from, to);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public void move(String from, String to) throws RepositoryException {
        try {
            this.remote.move(from, to);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public QueryManager getQueryManager() throws RepositoryException {
        try {
            RemoteQueryManager manager = this.remote.getQueryManager();
            return this.getFactory().getQueryManager(this.session, manager);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public NamespaceRegistry getNamespaceRegistry() throws RepositoryException {
        try {
            RemoteNamespaceRegistry registry = this.remote.getNamespaceRegistry();
            return this.getFactory().getNamespaceRegistry(registry);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public NodeTypeManager getNodeTypeManager() throws RepositoryException {
        try {
            RemoteNodeTypeManager manager = this.remote.getNodeTypeManager();
            return this.getFactory().getNodeTypeManager(manager);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public ObservationManager getObservationManager() throws RepositoryException {
        if (this.observationManager == null) {
            try {
                this.observationManager = this.getFactory().getObservationManager(this, this.remote.getObservationManager());
            }
            catch (RemoteException ex) {
                throw new RemoteRepositoryException(ex);
            }
        }
        return this.observationManager;
    }

    public void clone(String workspace, String src, String dst, boolean removeExisting) throws RepositoryException {
        try {
            this.remote.clone(workspace, src, dst, removeExisting);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public String[] getAccessibleWorkspaceNames() throws RepositoryException {
        try {
            return this.remote.getAccessibleWorkspaceNames();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public ContentHandler getImportContentHandler(final String path, final int mode) throws RepositoryException {
        this.getSession().getItem(path);
        try {
            final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            return new DefaultContentHandler(SerializingContentHandler.getSerializer(buffer)){

                @Override
                public void endDocument() throws SAXException {
                    super.endDocument();
                    try {
                        ClientWorkspace.this.remote.importXML(path, buffer.toByteArray(), mode);
                    }
                    catch (Exception e) {
                        throw new SAXException("XML import failed", e);
                    }
                }
            };
        }
        catch (SAXException e) {
            throw new RepositoryException("XML serialization failed", (Throwable)e);
        }
    }

    public void importXML(String path, InputStream xml, int uuidBehaviour) throws IOException, RepositoryException {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] bytes = new byte[4096];
            int n = xml.read(bytes);
            while (n != -1) {
                buffer.write(bytes, 0, n);
                n = xml.read(bytes);
            }
            this.remote.importXML(path, buffer.toByteArray(), uuidBehaviour);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
        finally {
            try {
                xml.close();
            }
            catch (IOException ignore) {}
        }
    }

    public void restore(Version[] versions, boolean removeExisting) throws RepositoryException {
        this.getVersionManager().restore(versions, removeExisting);
    }

    public void createWorkspace(String name) throws RepositoryException {
        try {
            this.remote.createWorkspace(name, null);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public void createWorkspace(String name, String srcWorkspace) throws RepositoryException {
        try {
            this.remote.createWorkspace(name, srcWorkspace);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public void deleteWorkspace(String name) throws RepositoryException {
        try {
            this.remote.deleteWorkspace(name);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public LockManager getLockManager() throws RepositoryException {
        if (this.lockManager == null) {
            try {
                this.lockManager = this.getFactory().getLockManager(this.session, this.remote.getLockManager());
            }
            catch (RemoteException ex) {
                throw new RemoteRepositoryException(ex);
            }
        }
        return this.lockManager;
    }

    public VersionManager getVersionManager() throws RepositoryException {
        if (this.versionManager == null) {
            try {
                this.versionManager = this.getFactory().getVersionManager(this.session, this.remote.getVersionManager());
            }
            catch (RemoteException ex) {
                throw new RemoteRepositoryException(ex);
            }
        }
        return this.versionManager;
    }
}

