/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.value;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.jackrabbit.rmi.value.AbstractValue;

class DateValue
extends AbstractValue {
    private static final long serialVersionUID = -2382837055824423966L;
    private static final DecimalFormat XX_FORMAT = new DecimalFormat("00");
    private static final DecimalFormat XXX_FORMAT = new DecimalFormat("000");
    private static final DecimalFormat XXXX_FORMAT = new DecimalFormat("0000");
    private final Calendar value;

    public DateValue(Calendar value) {
        this.value = value;
    }

    public int getType() {
        return 5;
    }

    @Override
    public Calendar getDate() {
        return (Calendar)this.value.clone();
    }

    @Override
    public BigDecimal getDecimal() {
        return new BigDecimal(this.value.getTimeInMillis());
    }

    @Override
    public double getDouble() {
        return this.value.getTimeInMillis();
    }

    @Override
    public long getLong() {
        return this.value.getTimeInMillis();
    }

    public String getString() {
        int year = this.value.get(1);
        if (this.value.isSet(0) && this.value.get(0) == 0) {
            year = 0 - year + 1;
        }
        StringBuilder buf = new StringBuilder(32);
        buf.append(XXXX_FORMAT.format(year));
        buf.append('-');
        buf.append(XX_FORMAT.format(this.value.get(2) + 1));
        buf.append('-');
        buf.append(XX_FORMAT.format(this.value.get(5)));
        buf.append('T');
        buf.append(XX_FORMAT.format(this.value.get(11)));
        buf.append(':');
        buf.append(XX_FORMAT.format(this.value.get(12)));
        buf.append(':');
        buf.append(XX_FORMAT.format(this.value.get(13)));
        buf.append('.');
        buf.append(XXX_FORMAT.format(this.value.get(14)));
        TimeZone tz = this.value.getTimeZone();
        int offset = tz.getOffset(this.value.getTimeInMillis()) / 1000 / 60;
        if (offset != 0) {
            int hours = Math.abs(offset / 60);
            int minutes = Math.abs(offset % 60);
            buf.append(offset < 0 ? (char)'-' : '+');
            buf.append(XX_FORMAT.format(hours));
            buf.append(':');
            buf.append(XX_FORMAT.format(minutes));
        } else {
            buf.append('Z');
        }
        return buf.toString();
    }
}

