/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.jcr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Item;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.Version;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceIteratorImpl;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.io.InputContext;
import org.apache.jackrabbit.webdav.io.OutputContext;
import org.apache.jackrabbit.webdav.jcr.AbstractResource;
import org.apache.jackrabbit.webdav.jcr.ItemResourceConstants;
import org.apache.jackrabbit.webdav.jcr.JcrDavException;
import org.apache.jackrabbit.webdav.jcr.JcrDavSession;
import org.apache.jackrabbit.webdav.jcr.property.NamespacesProperty;
import org.apache.jackrabbit.webdav.jcr.version.report.JcrPrivilegeReport;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.version.LabelInfo;
import org.apache.jackrabbit.webdav.version.MergeInfo;
import org.apache.jackrabbit.webdav.version.UpdateInfo;
import org.apache.jackrabbit.webdav.version.VersionControlledResource;
import org.apache.jackrabbit.webdav.version.VersionHistoryResource;
import org.apache.jackrabbit.webdav.version.WorkspaceResource;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WorkspaceResourceImpl
extends AbstractResource
implements WorkspaceResource,
VersionControlledResource {
    private static Logger log = LoggerFactory.getLogger((Class)WorkspaceResourceImpl.class);

    WorkspaceResourceImpl(DavResourceLocator locator, JcrDavSession session, DavResourceFactory factory) {
        super(locator, session, factory);
        this.initLockSupport();
        this.initSupportedReports();
    }

    public String getSupportedMethods() {
        StringBuffer sb = new StringBuffer("OPTIONS, GET, HEAD, POST, TRACE, PROPFIND, PROPPATCH, MKCOL, COPY, PUT, DELETE, MOVE, LOCK, UNLOCK");
        sb.append(", ");
        sb.append("REPORT, MKWORKSPACE");
        sb.append(", ");
        sb.append("SEARCH");
        sb.append(", ");
        sb.append("UPDATE");
        return sb.toString();
    }

    public boolean exists() {
        return true;
    }

    public boolean isCollection() {
        return true;
    }

    public String getDisplayName() {
        return this.getLocator().getWorkspaceName();
    }

    public long getModificationTime() {
        return new Date().getTime();
    }

    public void spool(OutputContext outputContext) throws IOException {
        outputContext.setContentLength(0L);
        outputContext.setModificationTime(this.getModificationTime());
    }

    public DavResource getCollection() {
        DavResource collection = null;
        DavResourceLocator parentLoc = this.getLocator().getFactory().createResourceLocator(this.getLocator().getPrefix(), null, null);
        try {
            collection = this.createResourceFromLocator(parentLoc);
        }
        catch (DavException e) {
            log.error("Unexpected error while retrieving collection: " + e.getMessage());
        }
        return collection;
    }

    public void addMember(DavResource resource, InputContext inputContext) throws DavException {
        log.error("Cannot add a new member to the workspace resource.");
        throw new DavException(403);
    }

    public DavResourceIterator getMembers() {
        ArrayList<DavResource> l = new ArrayList<DavResource>();
        try {
            DavResourceLocator loc = this.getLocatorFromItem((Item)this.getRepositorySession().getRootNode());
            l.add(this.createResourceFromLocator(loc));
        }
        catch (DavException e) {
            log.error("Internal error while building resource for the root node.", (Throwable)e);
        }
        catch (RepositoryException e) {
            log.error("Internal error while building resource for the root node.", (Throwable)e);
        }
        return new DavResourceIteratorImpl(l);
    }

    public void removeMember(DavResource member) throws DavException {
        log.error("Cannot add a remove the root node.");
        throw new DavException(403);
    }

    public void setProperty(DavProperty property) throws DavException {
        if (ItemResourceConstants.JCR_NAMESPACES.equals((Object)property.getName())) {
            NamespacesProperty nsp = new NamespacesProperty(property);
            try {
                HashMap changes = new HashMap(nsp.getNamespaces());
                NamespaceRegistry nsReg = this.getRepositorySession().getWorkspace().getNamespaceRegistry();
                String[] registeredPrefixes = nsReg.getPrefixes();
                for (int i = 0; i < registeredPrefixes.length; ++i) {
                    String prfx = registeredPrefixes[i];
                    if (!changes.containsKey(prfx)) {
                        nsReg.unregisterNamespace(prfx);
                        continue;
                    }
                    if (!changes.get(prfx).equals(nsReg.getURI(prfx))) continue;
                    changes.remove(prfx);
                }
                Iterator prefixIt = changes.keySet().iterator();
                while (prefixIt.hasNext()) {
                    String prefix = (String)prefixIt.next();
                    String uri = (String)changes.get(prefix);
                    nsReg.registerNamespace(prefix, uri);
                }
            }
            catch (RepositoryException e) {
                throw new JcrDavException(e);
            }
        } else {
            throw new DavException(409);
        }
    }

    public MultiStatusResponse alterProperties(List changeList) throws DavException {
        Object propEntry;
        if (changeList.size() == 1) {
            propEntry = changeList.get(0);
            if (!(propEntry instanceof DavProperty) || !ItemResourceConstants.JCR_NAMESPACES.equals((Object)((DavProperty)propEntry).getName())) {
                throw new DavException(409);
            }
        } else {
            throw new DavException(409);
        }
        DavProperty namespaceProp = (DavProperty)propEntry;
        this.setProperty(namespaceProp);
        return new MultiStatusResponse(this.getHref(), 200);
    }

    public void addVersionControl() throws DavException {
        throw new DavException(403);
    }

    public String checkin() throws DavException {
        throw new DavException(403);
    }

    public void checkout() throws DavException {
        throw new DavException(403);
    }

    public void uncheckout() throws DavException {
        throw new DavException(403);
    }

    public MultiStatus update(UpdateInfo updateInfo) throws DavException {
        if (updateInfo == null) {
            throw new DavException(400, "Valid update request body required.");
        }
        if (!this.exists()) {
            throw new DavException(404);
        }
        Session session = this.getRepositorySession();
        MultiStatus ms = new MultiStatus();
        try {
            Element udElem = updateInfo.getUpdateElement();
            boolean removeExisting = DomUtil.hasChildElement((Node)udElem, (String)"removeexisting", (Namespace)ItemResourceConstants.NAMESPACE);
            AbstractResource.EListener el = new AbstractResource.EListener(updateInfo.getPropertyNameSet(), ms);
            this.registerEventListener(el, session.getRootNode().getPath());
            String[] hrefs = updateInfo.getVersionHref();
            if (hrefs == null || hrefs.length < 1) {
                throw new DavException(400, "Invalid update request body: at least a single version href must be specified.");
            }
            Version[] versions = new Version[hrefs.length];
            for (int i = 0; i < hrefs.length; ++i) {
                DavResourceLocator vLoc = this.getLocator().getFactory().createResourceLocator(this.getLocator().getPrefix(), hrefs[i]);
                String versionPath = vLoc.getRepositoryPath();
                Item item = this.getRepositorySession().getItem(versionPath);
                if (!(item instanceof Version)) {
                    throw new DavException(400, "Invalid update request body: href does not identify a version " + hrefs[i]);
                }
                versions[i] = (Version)item;
            }
            session.getWorkspace().restore(versions, removeExisting);
            this.unregisterEventListener(el);
        }
        catch (RepositoryException e) {
            throw new JcrDavException(e);
        }
        return ms;
    }

    public MultiStatus merge(MergeInfo mergeInfo) throws DavException {
        throw new DavException(403);
    }

    public void label(LabelInfo labelInfo) throws DavException {
        throw new DavException(403);
    }

    public VersionHistoryResource getVersionHistory() throws DavException {
        throw new DavException(403);
    }

    protected void initLockSupport() {
    }

    protected void initSupportedReports() {
        super.initSupportedReports();
        this.supportedReports.addReportType(JcrPrivilegeReport.PRIVILEGES_REPORT);
    }

    protected String getWorkspaceHref() {
        return this.getHref();
    }

    protected void initProperties() {
        super.initProperties();
        try {
            NamespaceRegistry nsReg = this.getRepositorySession().getWorkspace().getNamespaceRegistry();
            NamespacesProperty namespacesProp = new NamespacesProperty(nsReg);
            this.properties.add((DavProperty)namespacesProp);
        }
        catch (RepositoryException e) {
            log.error("Failed to access NamespaceRegistry: " + e.getMessage());
        }
    }
}

