/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.jcr.search;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.value.ValueHelper;
import org.apache.jackrabbit.webdav.jcr.ItemResourceConstants;
import org.apache.jackrabbit.webdav.property.AbstractDavProperty;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SearchResultProperty
extends AbstractDavProperty
implements ItemResourceConstants {
    private static Logger log = LoggerFactory.getLogger((Class)SearchResultProperty.class);
    public static final DavPropertyName SEARCH_RESULT_PROPERTY = DavPropertyName.create((String)"search-result-property", (Namespace)ItemResourceConstants.NAMESPACE);
    private static final String COLUMN = "column";
    private final String[] columnNames;
    private final Value[] values;

    public SearchResultProperty(String[] columnNames, Value[] values) {
        super(SEARCH_RESULT_PROPERTY, true);
        this.columnNames = columnNames;
        this.values = values;
    }

    public SearchResultProperty(DavProperty property, ValueFactory valueFactory) throws RepositoryException {
        super(property.getName(), true);
        if (!SEARCH_RESULT_PROPERTY.equals((Object)this.getName())) {
            throw new IllegalArgumentException("SearchResultProperty may only be created from a property named " + SEARCH_RESULT_PROPERTY.toString());
        }
        ArrayList colList = new ArrayList();
        ArrayList valList = new ArrayList();
        Object propValue = property.getValue();
        if (propValue instanceof List) {
            Iterator elemIt = ((List)propValue).iterator();
            while (elemIt.hasNext()) {
                Object el = elemIt.next();
                if (!(el instanceof Element)) continue;
                this.parseColumnElement((Element)el, colList, valList, valueFactory);
            }
        } else if (propValue instanceof Element) {
            this.parseColumnElement((Element)property.getValue(), colList, valList, valueFactory);
        } else {
            new IllegalArgumentException("SearchResultProperty requires a list of 'dcr:column' xml elements.");
        }
        this.columnNames = colList.toArray(new String[colList.size()]);
        this.values = valList.toArray(new Value[valList.size()]);
    }

    private void parseColumnElement(Element columnElement, List columnNames, List values, ValueFactory valueFactory) throws ValueFormatException, RepositoryException {
        Value jcrValue;
        if (!DomUtil.matches((Node)columnElement, (String)COLUMN, (Namespace)ItemResourceConstants.NAMESPACE)) {
            log.debug("dcr:column element expected within search result.");
            return;
        }
        columnNames.add(DomUtil.getChildText((Element)columnElement, (String)JCR_NAME.getName(), (Namespace)JCR_NAME.getNamespace()));
        Element valueElement = DomUtil.getChildElement((Node)columnElement, (String)JCR_VALUE.getName(), (Namespace)JCR_VALUE.getNamespace());
        if (valueElement != null) {
            String typeStr = DomUtil.getAttribute((Element)valueElement, (String)"type", (Namespace)ItemResourceConstants.NAMESPACE);
            jcrValue = ValueHelper.deserialize((String)DomUtil.getText((Element)valueElement), (int)PropertyType.valueFromName((String)typeStr), (boolean)true, (ValueFactory)valueFactory);
        } else {
            jcrValue = null;
        }
        values.add(jcrValue);
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public Value[] getValues() {
        return this.values;
    }

    public Object getValue() {
        return this.values;
    }

    public Element toXml(Document document) {
        Element elem = this.getName().toXml(document);
        for (int i = 0; i < this.columnNames.length; ++i) {
            String propertyName = this.columnNames[i];
            Value propertyValue = this.values[i];
            Element columnEl = DomUtil.addChildElement((Element)elem, (String)COLUMN, (Namespace)ItemResourceConstants.NAMESPACE);
            DomUtil.addChildElement((Element)columnEl, (String)JCR_NAME.getName(), (Namespace)JCR_NAME.getNamespace(), (String)propertyName);
            if (propertyValue == null) continue;
            try {
                String serializedValue = ValueHelper.serialize((Value)propertyValue, (boolean)true);
                Element xmlValue = DomUtil.addChildElement((Element)columnEl, (String)"value", (Namespace)ItemResourceConstants.NAMESPACE, (String)serializedValue);
                String type = PropertyType.nameFromValue((int)propertyValue.getType());
                DomUtil.setAttribute((Element)xmlValue, (String)"type", (Namespace)ItemResourceConstants.NAMESPACE, (String)type);
                continue;
            }
            catch (RepositoryException e) {
                log.error(e.toString());
            }
        }
        return elem;
    }
}

