/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.jcr.version.report;

import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.jcr.ItemResourceConstants;
import org.apache.jackrabbit.webdav.jcr.version.report.AbstractJcrReport;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.version.report.ReportType;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RegisteredNamespacesReport
extends AbstractJcrReport
implements ItemResourceConstants {
    private static Logger log = LoggerFactory.getLogger((Class)RegisteredNamespacesReport.class);
    public static final ReportType REGISTERED_NAMESPACES_REPORT = ReportType.register((String)"registerednamespaces", (Namespace)ItemResourceConstants.NAMESPACE, (Class)RegisteredNamespacesReport.class);
    private NamespaceRegistry nsReg;

    public ReportType getType() {
        return REGISTERED_NAMESPACES_REPORT;
    }

    public boolean isMultiStatusReport() {
        return false;
    }

    public void init(DavResource resource, ReportInfo info) throws DavException {
        super.init(resource, info);
        try {
            this.nsReg = this.getRepositorySession().getWorkspace().getNamespaceRegistry();
        }
        catch (RepositoryException e) {
            throw new DavException(500);
        }
    }

    public Element toXml(Document document) {
        Element report = DomUtil.createElement((Document)document, (String)"registerednamespaces-report", (Namespace)NAMESPACE);
        try {
            String[] prefixes = this.nsReg.getPrefixes();
            for (int i = 0; i < prefixes.length; ++i) {
                Element elem = DomUtil.addChildElement((Element)report, (String)"namespace", (Namespace)NAMESPACE);
                DomUtil.addChildElement((Element)elem, (String)"prefix", (Namespace)NAMESPACE, (String)prefixes[i]);
                DomUtil.addChildElement((Element)elem, (String)"uri", (Namespace)NAMESPACE, (String)this.nsReg.getURI(prefixes[i]));
            }
        }
        catch (RepositoryException e) {
            log.error(e.getMessage());
        }
        return report;
    }
}

