/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.server.io;

import java.util.ArrayList;
import java.util.List;
import org.apache.jackrabbit.server.io.CopyMoveContext;
import org.apache.jackrabbit.server.io.CopyMoveHandler;
import org.apache.jackrabbit.server.io.CopyMoveManager;
import org.apache.jackrabbit.server.io.DefaultHandler;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyMoveManagerImpl
implements CopyMoveManager {
    private static Logger log = LoggerFactory.getLogger(CopyMoveManagerImpl.class);
    private static CopyMoveManager DEFAULT_MANAGER;
    private final List<CopyMoveHandler> copyMoveHandlers = new ArrayList<CopyMoveHandler>();

    public boolean copy(CopyMoveContext context, DavResource source, DavResource destination) throws DavException {
        boolean success = false;
        CopyMoveHandler[] copyMoveHandlers = this.getCopyMoveHandlers();
        for (int i = 0; i < copyMoveHandlers.length && !success; ++i) {
            CopyMoveHandler cmh = copyMoveHandlers[i];
            if (!cmh.canCopy(context, source, destination)) continue;
            success = cmh.copy(context, source, destination);
        }
        return success;
    }

    public boolean move(CopyMoveContext context, DavResource source, DavResource destination) throws DavException {
        boolean success = false;
        CopyMoveHandler[] copyMoveHandlers = this.getCopyMoveHandlers();
        for (int i = 0; i < copyMoveHandlers.length && !success; ++i) {
            CopyMoveHandler cmh = copyMoveHandlers[i];
            if (!cmh.canMove(context, source, destination)) continue;
            success = cmh.move(context, source, destination);
        }
        return success;
    }

    public void addCopyMoveHandler(CopyMoveHandler copyMoveHandler) {
        if (copyMoveHandler == null) {
            throw new IllegalArgumentException("'null' is not a valid copyMoveHandler.");
        }
        this.copyMoveHandlers.add(copyMoveHandler);
    }

    public CopyMoveHandler[] getCopyMoveHandlers() {
        return this.copyMoveHandlers.toArray(new CopyMoveHandler[this.copyMoveHandlers.size()]);
    }

    public static CopyMoveManager getDefaultManager() {
        if (DEFAULT_MANAGER == null) {
            DEFAULT_MANAGER = new CopyMoveManagerImpl();
            DEFAULT_MANAGER.addCopyMoveHandler(new DefaultHandler());
        }
        return DEFAULT_MANAGER;
    }
}

