/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.server.remoting.davex;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.commons.json.JsonUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JsonWriter {
    private final Writer writer;

    JsonWriter(Writer writer) {
        this.writer = writer;
    }

    void write(Node node, int maxLevels) throws RepositoryException, IOException {
        this.write(node, 0, maxLevels);
    }

    void write(Collection<Node> nodes, int maxLevels) throws RepositoryException, IOException {
        this.writer.write(123);
        JsonWriter.writeKey(this.writer, "nodes");
        this.writer.write(123);
        boolean first = true;
        for (Node node : nodes) {
            if (first) {
                first = false;
            } else {
                this.writer.write(44);
            }
            JsonWriter.writeKey(this.writer, node.getPath());
            this.write(node, maxLevels);
        }
        this.writer.write(125);
        this.writer.write(125);
    }

    private void write(Node node, int currentLevel, int maxLevels) throws RepositoryException, IOException {
        this.writer.write(123);
        PropertyIterator props = node.getProperties();
        while (props.hasNext()) {
            Property prop = props.nextProperty();
            JsonWriter.writeProperty(this.writer, prop);
            this.writer.write(44);
        }
        NodeIterator children = node.getNodes();
        if (!children.hasNext()) {
            JsonWriter.writeKeyValue(this.writer, "::NodeIteratorSize", 0L);
        } else {
            while (children.hasNext()) {
                Node n = children.nextNode();
                String name = n.getName();
                int index = n.getIndex();
                if (index > 1) {
                    JsonWriter.writeKey(this.writer, name + "[" + index + "]");
                } else {
                    JsonWriter.writeKey(this.writer, name);
                }
                if (maxLevels < 0 || currentLevel < maxLevels) {
                    this.write(n, currentLevel + 1, maxLevels);
                } else {
                    JsonWriter.writeChildInfo(this.writer, n);
                }
                if (!children.hasNext()) continue;
                this.writer.write(44);
            }
        }
        this.writer.write(125);
    }

    private static void writeChildInfo(Writer w, Node n) throws RepositoryException, IOException {
        w.write(123);
        if (n.isNodeType("mix:referenceable") && n.hasProperty("jcr:uuid")) {
            JsonWriter.writeProperty(w, n.getProperty("jcr:uuid"));
        }
        w.write(125);
    }

    private static void writeProperty(Writer w, Property p) throws RepositoryException, IOException {
        int type = p.getType();
        if (type == 2) {
            String key = ":" + p.getName();
            if (p.isMultiple()) {
                long[] binLengths = p.getLengths();
                JsonWriter.writeKeyArray(w, key, binLengths);
            } else {
                JsonWriter.writeKeyValue(w, key, p.getLength());
            }
        } else {
            boolean isMultiple = p.isMultiple();
            if (JsonWriter.requiresTypeInfo(type) || isMultiple && p.getValues().length == 0) {
                JsonWriter.writeKeyValue(w, ":" + p.getName(), PropertyType.nameFromValue((int)type), true);
            }
            if (isMultiple) {
                JsonWriter.writeKeyArray(w, p.getName(), p.getValues());
            } else {
                JsonWriter.writeKeyValue(w, p.getName(), p.getValue());
            }
        }
    }

    private static boolean requiresTypeInfo(int type) {
        switch (type) {
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    private static void writeKeyValue(Writer w, String key, String value, boolean hasNext) throws IOException {
        JsonWriter.writeKey(w, key);
        w.write(JsonUtil.getJsonString((String)value));
        if (hasNext) {
            w.write(44);
        }
    }

    private static void writeKeyValue(Writer w, String key, Value value) throws RepositoryException, IOException {
        JsonWriter.writeKey(w, key);
        w.write(JsonWriter.getJsonValue(value));
    }

    private static void writeKeyArray(Writer w, String key, Value[] values) throws RepositoryException, IOException {
        JsonWriter.writeKey(w, key);
        w.write(91);
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                w.write(44);
            }
            w.write(JsonWriter.getJsonValue(values[i]));
        }
        w.write(93);
    }

    private static void writeKeyValue(Writer w, String key, long binLength) throws IOException {
        JsonWriter.writeKey(w, key);
        w.write(binLength + "");
    }

    private static void writeKeyArray(Writer w, String key, long[] binLengths) throws RepositoryException, IOException {
        JsonWriter.writeKey(w, key);
        w.write(91);
        for (int i = 0; i < binLengths.length; ++i) {
            String delim = i == 0 ? "" : ",";
            w.write(delim + binLengths[i]);
        }
        w.write(93);
    }

    private static void writeKey(Writer w, String key) throws IOException {
        w.write(JsonUtil.getJsonString((String)key));
        w.write(58);
    }

    private static String getJsonValue(Value v) throws RepositoryException, IOException {
        switch (v.getType()) {
            case 2: {
                throw new IllegalArgumentException();
            }
            case 3: 
            case 4: 
            case 6: {
                return v.getString();
            }
        }
        return JsonUtil.getJsonString((String)v.getString());
    }
}

