/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.AbstractWorkspaceCopyBetweenTest;

abstract class AbstractWorkspaceReferenceableTest
extends AbstractWorkspaceCopyBetweenTest {
    AbstractWorkspaceReferenceableTest() {
    }

    protected void setUp() throws Exception {
        super.setUp();
        NodeTypeManager ntMgr = this.superuser.getWorkspace().getNodeTypeManager();
        try {
            NodeType referenceableNt = ntMgr.getNodeType(this.mixReferenceable);
            if (referenceableNt == null) {
                throw new NotExecutableException("Repository does not support Referencing: mixin nodetype '" + this.mixReferenceable + "' is missing.");
            }
        }
        catch (NoSuchNodeTypeException e) {
            throw new NotExecutableException("Repository does not support Referencing: mixin nodetype '" + this.mixReferenceable + "' is missing.");
        }
    }

    protected Node addMixinReferenceableToNode(Node node) throws RepositoryException {
        if (!node.isNodeType(this.mixReferenceable)) {
            node.addMixin(this.mixReferenceable);
            node.save();
        }
        return node;
    }
}

