/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.Node;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;

public class SetPropertyNodeTest
extends AbstractJCRTest {
    private Node testNode;
    private Node n1;
    private Node n2;

    protected void setUp() throws Exception {
        super.setUp();
        this.testNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.n1 = this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        this.n2 = this.testRootNode.addNode(this.nodeName3, this.testNodeType);
        this.testRootNode.save();
        this.ensureCanSetProperty(this.testNode, this.propertyName1, this.testNode.getSession().getValueFactory().createValue(this.n1));
        if (!this.n1.isNodeType(this.mixReferenceable)) {
            throw new NotExecutableException("Node " + this.nodeName2 + " with nodetype " + this.testNodeType + " is not mix:referenceable.");
        }
        if (!this.n2.isNodeType(this.mixReferenceable)) {
            throw new NotExecutableException("Node " + this.nodeName3 + " with nodetype " + this.testNodeType + " is not mix:referenceable.");
        }
    }

    protected void tearDown() throws Exception {
        this.testNode = null;
        this.n1 = null;
        this.n2 = null;
        super.tearDown();
    }

    public void testNewNodePropertySession() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.n1);
        this.superuser.save();
        SetPropertyNodeTest.assertEquals((String)"Setting property with Node.setProperty(String, Node) and Session.save() not working", (String)this.n1.getUUID(), (String)this.testNode.getProperty(this.propertyName1).getString());
    }

    public void testModifyNodePropertySession() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.n1);
        this.superuser.save();
        this.testNode.setProperty(this.propertyName1, this.n2);
        this.superuser.save();
        SetPropertyNodeTest.assertEquals((String)"Modifying property with Node.setProperty(String, Node) and Session.save() not working", (String)this.n2.getUUID(), (String)this.testNode.getProperty(this.propertyName1).getString());
    }

    public void testNewNodePropertyParent() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.n1);
        this.testRootNode.save();
        SetPropertyNodeTest.assertEquals((String)"Setting property with Node.setProperty(String, Node) and parentNode.save() not working", (String)this.n1.getUUID(), (String)this.testNode.getProperty(this.propertyName1).getString());
    }

    public void testModifyNodePropertyParent() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.n1);
        this.testRootNode.save();
        this.testNode.setProperty(this.propertyName1, this.n2);
        this.testRootNode.save();
        SetPropertyNodeTest.assertEquals((String)"Modifying property with Node.setProperty(String, Node) and parentNode.save() not working", (String)this.n2.getUUID(), (String)this.testNode.getProperty(this.propertyName1).getString());
    }

    public void testRemoveNodePropertySession() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.n1);
        this.superuser.save();
        this.testNode.setProperty(this.propertyName1, (Node)null);
        this.superuser.save();
        SetPropertyNodeTest.assertFalse((String)"Removing property with Node.setProperty(String, (Node)null) and Session.save() not working", (boolean)this.testNode.hasProperty(this.propertyName1));
    }

    public void testRemoveNodePropertyParent() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.n1);
        this.testRootNode.save();
        this.testNode.setProperty(this.propertyName1, (Node)null);
        this.testRootNode.save();
        SetPropertyNodeTest.assertFalse((String)"Removing property with Node.setProperty(String, (Node)null) and parentNode.save() not working", (boolean)this.testNode.hasProperty(this.propertyName1));
    }
}

