/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.observation;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import org.apache.jackrabbit.test.api.observation.AbstractObservationTest;
import org.apache.jackrabbit.test.api.observation.EventResult;

public class NodeMovedTest
extends AbstractObservationTest {
    public void testMoveTree() throws RepositoryException {
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        n1.addNode(this.nodeName2, this.testNodeType);
        this.testRootNode.save();
        EventResult addNodeListener = new EventResult(this.log);
        EventResult removeNodeListener = new EventResult(this.log);
        this.addEventListener(addNodeListener, 1);
        this.addEventListener(removeNodeListener, 2);
        this.superuser.move(n1.getPath(), this.testRoot + "/" + this.nodeName3);
        this.testRootNode.save();
        Event[] added = addNodeListener.getEvents(5000L);
        Event[] removed = removeNodeListener.getEvents(5000L);
        this.removeEventListener(addNodeListener);
        this.removeEventListener(removeNodeListener);
        this.checkNodeAdded(added, new String[]{this.nodeName3}, new String[]{this.nodeName3 + "/" + this.nodeName2});
        this.checkNodeRemoved(removed, new String[]{this.nodeName1}, new String[]{this.nodeName1 + "/" + this.nodeName2});
    }

    public void testMoveNode() throws RepositoryException {
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        Node n2 = n1.addNode(this.nodeName2, this.testNodeType);
        this.testRootNode.save();
        EventResult addNodeListener = new EventResult(this.log);
        EventResult removeNodeListener = new EventResult(this.log);
        this.addEventListener(addNodeListener, 1);
        this.addEventListener(removeNodeListener, 2);
        this.superuser.move(n2.getPath(), this.testRoot + "/" + this.nodeName2);
        this.testRootNode.save();
        Event[] added = addNodeListener.getEvents(5000L);
        Event[] removed = removeNodeListener.getEvents(5000L);
        this.removeEventListener(addNodeListener);
        this.removeEventListener(removeNodeListener);
        this.checkNodeAdded(added, new String[]{this.nodeName2}, null);
        this.checkNodeRemoved(removed, new String[]{this.nodeName1 + "/" + this.nodeName2}, null);
    }

    public void testMoveWithRemove() throws RepositoryException {
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        Node n2 = n1.addNode(this.nodeName2, this.testNodeType);
        Node n3 = this.testRootNode.addNode(this.nodeName3, this.testNodeType);
        this.testRootNode.save();
        EventResult addNodeListener = new EventResult(this.log);
        EventResult removeNodeListener = new EventResult(this.log);
        this.addEventListener(addNodeListener, 1);
        this.addEventListener(removeNodeListener, 2);
        this.superuser.move(n2.getPath(), n3.getPath() + "/" + this.nodeName2);
        n1.remove();
        this.testRootNode.save();
        Event[] added = addNodeListener.getEvents(5000L);
        Event[] removed = removeNodeListener.getEvents(5000L);
        this.removeEventListener(addNodeListener);
        this.removeEventListener(removeNodeListener);
        this.checkNodeAdded(added, new String[]{this.nodeName3 + "/" + this.nodeName2}, null);
        this.checkNodeRemoved(removed, new String[]{this.nodeName1 + "/" + this.nodeName2, this.nodeName1}, null);
    }
}

