/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.observation;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.observation.AbstractObservationTest;
import org.apache.jackrabbit.test.api.observation.EventResult;

public class NodeReorderTest
extends AbstractObservationTest {
    public void testNodeReorder() throws RepositoryException, NotExecutableException {
        if (!this.testRootNode.getDefinition().getDeclaringNodeType().hasOrderableChildNodes()) {
            throw new NotExecutableException("Node at '" + this.testRoot + "' does not support orderable child nodes.");
        }
        this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        this.testRootNode.addNode(this.nodeName3, this.testNodeType);
        this.testRootNode.save();
        EventResult addNodeListener = new EventResult(this.log);
        EventResult removeNodeListener = new EventResult(this.log);
        this.addEventListener(addNodeListener, 1);
        this.addEventListener(removeNodeListener, 2);
        this.testRootNode.orderBefore(this.nodeName3, this.nodeName2);
        this.testRootNode.save();
        Event[] added = addNodeListener.getEvents(5000L);
        Event[] removed = removeNodeListener.getEvents(5000L);
        this.removeEventListener(addNodeListener);
        this.removeEventListener(removeNodeListener);
        boolean reorderEnd = false;
        for (int i = 0; i < added.length; ++i) {
            if (!added[i].getPath().endsWith(this.nodeName2)) continue;
            reorderEnd = true;
            break;
        }
        if (reorderEnd) {
            this.checkNodeAdded(added, new String[]{this.nodeName2}, null);
            this.checkNodeRemoved(removed, new String[]{this.nodeName2}, null);
        } else {
            this.checkNodeAdded(added, new String[]{this.nodeName3}, null);
            this.checkNodeRemoved(removed, new String[]{this.nodeName3}, null);
        }
    }

    public void testNodeReorderSameName() throws RepositoryException, NotExecutableException {
        if (!this.testRootNode.getDefinition().getDeclaringNodeType().hasOrderableChildNodes()) {
            throw new NotExecutableException("Node at '" + this.testRoot + "' does not support orderable child nodes.");
        }
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        if (!n.getDefinition().allowsSameNameSiblings()) {
            throw new NotExecutableException("Node at " + this.testRoot + " does not allow same name siblings with name " + this.nodeName1);
        }
        this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.testRootNode.save();
        EventResult addNodeListener = new EventResult(this.log);
        EventResult removeNodeListener = new EventResult(this.log);
        this.addEventListener(addNodeListener, 1);
        this.addEventListener(removeNodeListener, 2);
        this.testRootNode.orderBefore(this.nodeName1 + "[3]", this.nodeName1 + "[2]");
        this.testRootNode.save();
        Event[] added = addNodeListener.getEvents(5000L);
        Event[] removed = removeNodeListener.getEvents(5000L);
        this.removeEventListener(addNodeListener);
        this.removeEventListener(removeNodeListener);
        boolean reorderEnd = false;
        for (int i = 0; i < added.length; ++i) {
            if (!added[i].getPath().endsWith(this.nodeName1 + "[3]")) continue;
            reorderEnd = true;
            break;
        }
        if (reorderEnd) {
            this.checkNodeAdded(added, new String[]{this.nodeName1 + "[3]"}, null);
            this.checkNodeRemoved(removed, new String[]{this.nodeName1 + "[2]"}, null);
        } else {
            this.checkNodeAdded(added, new String[]{this.nodeName1 + "[2]"}, null);
            this.checkNodeRemoved(removed, new String[]{this.nodeName1 + "[3]"}, null);
        }
    }

    public void testNodeReorderSameNameWithRemove() throws RepositoryException, NotExecutableException {
        if (!this.testRootNode.getDefinition().getDeclaringNodeType().hasOrderableChildNodes()) {
            throw new NotExecutableException("Node at '" + this.testRoot + "' does not support orderable child nodes.");
        }
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        if (!n.getDefinition().allowsSameNameSiblings()) {
            throw new NotExecutableException("Node at " + this.testRoot + " does not allow same name siblings with name " + this.nodeName1);
        }
        this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.testRootNode.addNode(this.nodeName3, this.testNodeType);
        this.testRootNode.save();
        EventResult addNodeListener = new EventResult(this.log);
        EventResult removeNodeListener = new EventResult(this.log);
        this.addEventListener(addNodeListener, 1);
        this.addEventListener(removeNodeListener, 2);
        this.testRootNode.orderBefore(this.nodeName1 + "[2]", null);
        this.testRootNode.getNode(this.nodeName3).remove();
        this.testRootNode.save();
        Event[] added = addNodeListener.getEvents(5000L);
        Event[] removed = removeNodeListener.getEvents(5000L);
        this.removeEventListener(addNodeListener);
        this.removeEventListener(removeNodeListener);
        boolean reorderEnd = false;
        for (int i = 0; i < added.length; ++i) {
            if (!added[i].getPath().endsWith(this.nodeName1 + "[3]")) continue;
            reorderEnd = true;
            break;
        }
        if (reorderEnd) {
            this.checkNodeAdded(added, new String[]{this.nodeName1 + "[3]"}, null);
            this.checkNodeRemoved(removed, new String[]{this.nodeName1 + "[2]", this.nodeName3}, null);
        } else {
            this.checkNodeAdded(added, new String[]{this.nodeName1 + "[2]"}, null);
            this.checkNodeRemoved(removed, new String[]{this.nodeName1 + "[3]", this.nodeName3}, null);
        }
    }
}

