/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.query;

import java.util.Arrays;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.query.AbstractQueryTest;

public class SQLJcrPathTest
extends AbstractQueryTest {
    private Session session;

    protected void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
        this.session = helper.getReadOnlySession();
        this.testRootNode = this.session.getRootNode().getNode(this.testPath);
    }

    protected void tearDown() throws Exception {
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        super.tearDown();
    }

    public void testJcrPath() throws RepositoryException, NotExecutableException {
        String nodeTypeName = this.session.getRootNode().getPrimaryNodeType().getName();
        String queryStatement = "select * from " + nodeTypeName;
        Query query = this.session.getWorkspace().getQueryManager().createQuery(queryStatement, "sql");
        QueryResult result = query.execute();
        SQLJcrPathTest.assertTrue((String)"jcr:path must be present in query result row", (boolean)Arrays.asList(result.getColumnNames()).contains(this.jcrPath));
    }
}

