/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.query;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.query.AbstractQueryTest;

public class SQLJoinTest
extends AbstractQueryTest {
    public void testJoin() throws RepositoryException {
        String testMixin;
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        if (this.needsMixin(n1, testMixin = this.mixReferenceable)) {
            n1.addMixin(testMixin);
        } else {
            testMixin = this.mixVersionable;
            if (this.needsMixin(n1, testMixin)) {
                n1.addMixin(testMixin);
            }
        }
        Node n2 = this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        this.testRootNode.save();
        SQLJoinTest.assertFalse((String)("Node at " + n2.getPath() + " should not have mixin " + testMixin), (boolean)n2.isNodeType(testMixin));
        StringBuffer query = new StringBuffer("SELECT * FROM ");
        query.append(this.testNodeType).append(", ").append(testMixin);
        query.append(" WHERE ");
        query.append(this.testNodeType).append(".").append(this.jcrPath);
        query.append(" = ");
        query.append(this.mixReferenceable).append(".").append(this.jcrPath);
        query.append(" AND ").append(this.jcrPath).append(" LIKE ");
        query.append("'").append(this.testRoot).append("/%'");
        this.executeSqlQuery(this.superuser, query.toString(), new Node[]{n1});
    }

    public void testJoinNtBase() throws RepositoryException {
        String testMixin;
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        if (this.needsMixin(n1, testMixin = this.mixReferenceable)) {
            n1.addMixin(testMixin);
        } else {
            testMixin = this.mixVersionable;
            if (this.needsMixin(n1, testMixin)) {
                n1.addMixin(testMixin);
            }
        }
        Node n2 = this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        this.testRootNode.save();
        SQLJoinTest.assertFalse((String)("Node at " + n2.getPath() + " should not have mixin " + testMixin), (boolean)n2.isNodeType(testMixin));
        StringBuffer query = new StringBuffer("SELECT * FROM ");
        query.append(this.ntBase).append(", ").append(testMixin);
        query.append(" WHERE ");
        query.append(this.testNodeType).append(".").append(this.jcrPath);
        query.append(" = ");
        query.append(this.mixReferenceable).append(".").append(this.jcrPath);
        query.append(" AND ").append(this.jcrPath).append(" LIKE ");
        query.append("'").append(this.testRoot).append("/%'");
        this.executeSqlQuery(this.superuser, query.toString(), new Node[]{n1});
    }

    public void testJoinFilterPrimaryType() throws RepositoryException {
        Node n2;
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        if (this.needsMixin(n1, this.mixReferenceable)) {
            n1.addMixin(this.mixReferenceable);
        }
        if (this.needsMixin(n2 = this.testRootNode.addNode(this.nodeName2, this.ntBase), this.mixReferenceable)) {
            n2.addMixin(this.mixReferenceable);
        }
        this.testRootNode.save();
        StringBuffer query = new StringBuffer("SELECT * FROM ");
        query.append(this.testNodeType).append(", ").append(this.ntBase);
        query.append(" WHERE ");
        query.append(this.testNodeType).append(".").append(this.jcrPath);
        query.append(" = ");
        query.append(this.mixReferenceable).append(".").append(this.jcrPath);
        query.append(" AND ").append(this.jcrPath).append(" LIKE ");
        query.append("'").append(this.testRoot).append("/%'");
        this.executeSqlQuery(this.superuser, query.toString(), new Node[]{n1});
    }

    public void testJoinSNS() throws RepositoryException, NotExecutableException {
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        if (this.needsMixin(n1, this.mixReferenceable)) {
            n1.addMixin(this.mixReferenceable);
        }
        if (!n1.getDefinition().allowsSameNameSiblings()) {
            throw new NotExecutableException("Node at " + this.testRoot + " does not allow same name siblings with name " + this.nodeName1);
        }
        this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        Node n2 = this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        n2.addMixin(this.mixReferenceable);
        this.testRootNode.save();
        StringBuffer query = new StringBuffer("SELECT * FROM ");
        query.append(this.testNodeType).append(", ").append(this.mixReferenceable);
        query.append(" WHERE ");
        query.append(this.testNodeType).append(".").append(this.jcrPath);
        query.append(" = ");
        query.append(this.mixReferenceable).append(".").append(this.jcrPath);
        query.append(" AND ").append(this.jcrPath).append(" LIKE ");
        query.append("'").append(this.testRoot).append("/%'");
        this.executeSqlQuery(this.superuser, query.toString(), new Node[]{n1, n2});
    }
}

