/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.query;

import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryResult;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.query.AbstractQueryTest;
import org.apache.jackrabbit.test.api.query.Statement;

public class XPathDocOrderTest
extends AbstractQueryTest {
    protected void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
    }

    public void testDocOrderPositionFunction() throws Exception {
        StringBuffer tmp = new StringBuffer("/");
        tmp.append(this.jcrRoot).append(this.testRoot).append("/*");
        tmp.append("[position()=2]");
        String resultPath = "";
        NodeIterator nodes = this.testRootNode.getNodes();
        while (nodes.hasNext() && nodes.getPosition() < 2L) {
            resultPath = nodes.nextNode().getPath();
        }
        this.docOrderTest(new Statement(tmp.toString(), "xpath"), resultPath);
    }

    public void testDocOrderPositionIndex() throws Exception {
        StringBuffer tmp = new StringBuffer("/");
        tmp.append(this.jcrRoot).append(this.testRoot).append("/*");
        tmp.append("[2]");
        String resultPath = "";
        NodeIterator nodes = this.testRootNode.getNodes();
        while (nodes.hasNext() && nodes.getPosition() < 2L) {
            resultPath = nodes.nextNode().getPath();
        }
        this.docOrderTest(new Statement(tmp.toString(), "xpath"), resultPath);
    }

    public void testDocOrderLastFunction() throws Exception {
        StringBuffer tmp = new StringBuffer("/");
        tmp.append(this.jcrRoot).append(this.testRoot).append("/*");
        tmp.append("[position()=last()]");
        String resultPath = "";
        NodeIterator nodes = this.testRootNode.getNodes();
        while (nodes.hasNext()) {
            resultPath = nodes.nextNode().getPath();
        }
        this.docOrderTest(new Statement(tmp.toString(), "xpath"), resultPath);
    }

    public void testDocOrderFirstFunction() throws Exception {
        StringBuffer tmp = new StringBuffer("/");
        tmp.append(this.jcrRoot).append(this.testRoot).append("/*");
        tmp.append("[first()]");
        String resultPath = this.testRootNode.getNodes().nextNode().getPath();
        this.docOrderTest(new Statement(tmp.toString(), "xpath"), resultPath);
    }

    private void docOrderTest(Statement stmt, String path) throws RepositoryException, NotExecutableException {
        if (!this.isSupported("query.xpath.doc.order")) {
            throw new NotExecutableException("Repository does not support document order on result set.");
        }
        int count = 0;
        NodeIterator it = this.testRootNode.getNodes();
        while (it.hasNext()) {
            ++count;
            it.nextNode();
        }
        if (count < 3) {
            throw new NotExecutableException("Workspace does not contain enough content under: " + this.testRoot + ". At least 3 nodes are required for this test.");
        }
        QueryResult result = this.execute(stmt);
        this.checkResult(result, 1);
        XPathDocOrderTest.assertEquals((String)"Wrong result node.", (String)path, (String)result.getNodes().nextNode().getPath());
    }
}

