/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.jackrabbit.test.RepositoryHelper;
import org.apache.jackrabbit.test.RepositoryHelperPool;

public class RepositoryHelperPoolImpl
implements RepositoryHelperPool {
    private static final String PROP_FILE = "repositoryHelperPool.properties";
    private List helpers = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryHelperPoolImpl() {
        InputStream in = RepositoryHelperPoolImpl.class.getClassLoader().getResourceAsStream(PROP_FILE);
        if (in != null) {
            try {
                Properties props = new Properties();
                props.load(in);
                int i = 0;
                while (true) {
                    String prefix = "helper." + i + ".";
                    HashMap<String, Object> helperProp = new HashMap<String, Object>();
                    Iterator<Map.Entry<Object, Object>> it = props.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry<Object, Object> entry = it.next();
                        String key = (String)entry.getKey();
                        if (!key.startsWith(prefix)) continue;
                        helperProp.put(key.substring(prefix.length()), entry.getValue());
                    }
                    if (helperProp.isEmpty()) {
                        break;
                    }
                    this.addHelper(new RepositoryHelper(helperProp));
                    ++i;
                }
            }
            catch (IOException e) {
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        if (this.helpers.isEmpty()) {
            this.addHelper(new RepositoryHelper());
        }
    }

    public synchronized void addHelper(RepositoryHelper helper) {
        this.helpers.add(helper);
    }

    public synchronized RepositoryHelper borrowHelper() throws InterruptedException {
        while (this.helpers.isEmpty()) {
            this.wait();
        }
        return (RepositoryHelper)this.helpers.remove(0);
    }

    public synchronized void returnHelper(RepositoryHelper helper) {
        this.helpers.add(helper);
        this.notifyAll();
    }
}

