/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.AbstractWorkspaceCopyTest;

public class WorkspaceMoveTest
extends AbstractWorkspaceCopyTest {
    public void testMoveNodes() throws RepositoryException {
        String dstAbsPath = this.node2.getPath() + "/" + this.node1.getName();
        this.workspace.move(this.node1.getPath(), dstAbsPath);
        WorkspaceMoveTest.assertFalse((boolean)this.superuser.hasPendingChanges());
    }

    public void testMoveNodesAbsolutePath() {
        try {
            String dstAbsPath = this.node2.getPath() + "/" + this.node1.getName() + "[2]";
            this.workspace.move(this.node1.getPath(), dstAbsPath);
            WorkspaceMoveTest.fail((String)"Moving a node to an absolute path containing index should not be possible.");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public void testMoveNodesConstraintViolationException() throws RepositoryException {
        String nodetype = this.testNodeTypeNoChildren == null ? this.ntBase : this.testNodeTypeNoChildren;
        Node subNodesNotAllowedNode = this.testRootNode.addNode(this.nodeName3, nodetype);
        this.testRootNode.save();
        try {
            String dstAbsPath = subNodesNotAllowedNode.getPath() + "/" + this.node2.getName();
            this.workspace.move(this.node2.getPath(), dstAbsPath);
            WorkspaceMoveTest.fail((String)"Moving a node below a node which can not have any sub nodes should throw a ConstraintViolationException.");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMoveNodesAccessDenied() throws RepositoryException {
        Session readOnlySuperuser = this.getHelper().getReadOnlySession();
        try {
            String dstAbsPath = this.node2.getPath() + "/" + this.node1.getName();
            try {
                readOnlySuperuser.getWorkspace().move(this.node1.getPath(), dstAbsPath);
                WorkspaceMoveTest.fail((String)"Copy in a read-only session should throw an AccessDeniedException.");
            }
            catch (AccessDeniedException accessDeniedException) {
                // empty catch block
            }
        }
        finally {
            readOnlySuperuser.logout();
        }
    }

    public void testMoveNodesPathNotExisting() throws RepositoryException {
        String srcAbsPath = this.node1.getPath();
        String dstAbsPath = this.node2.getPath() + "/" + this.node1.getName();
        String invalidSrcPath = srcAbsPath + "invalid";
        try {
            this.workspace.move(invalidSrcPath, dstAbsPath);
            WorkspaceMoveTest.fail((String)("Not existing source path '" + invalidSrcPath + "' should throw PathNotFoundException."));
        }
        catch (PathNotFoundException e) {
            // empty catch block
        }
        String invalidDstParentPath = this.node2.getPath() + "invalid/" + this.node1.getName();
        try {
            this.workspace.move(srcAbsPath, invalidDstParentPath);
            WorkspaceMoveTest.fail((String)("Not existing destination parent path '" + invalidDstParentPath + "' should throw PathNotFoundException."));
        }
        catch (PathNotFoundException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testMoveNodesLocked() throws RepositoryException, NotExecutableException {
        String dstAbsPath = this.node2.getPath() + "/" + this.node1.getName();
        Session otherSession = this.getHelper().getReadWriteSession();
        try {
            Node lockTarget = (Node)otherSession.getItem(this.node2.getPath());
            this.ensureMixinType(lockTarget, this.mixLockable);
            lockTarget.getParent().save();
            lockTarget.lock(true, true);
            try {
                this.workspace.move(this.node1.getPath(), dstAbsPath);
                WorkspaceMoveTest.fail((String)"LockException was expected.");
                return;
            }
            catch (LockException e) {
                return;
            }
            finally {
                lockTarget.unlock();
            }
        }
        finally {
            otherSession.logout();
        }
    }
}

