/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.query.qom;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.query.qom.EquiJoinCondition;
import javax.jcr.query.qom.JoinCondition;
import javax.jcr.query.qom.QueryObjectModel;
import org.apache.jackrabbit.test.api.query.qom.AbstractJoinTest;

public class EquiJoinConditionTest
extends AbstractJoinTest {
    private Node n1;
    private Node n2;

    protected void setUp() throws Exception {
        super.setUp();
        String value = this.createRandomString(10);
        this.n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.n1.setProperty(this.propertyName1, value);
        this.n2 = this.n1.addNode(this.nodeName2, this.testNodeType);
        this.n2.setProperty(this.propertyName1, value);
        this.n2.setProperty(this.propertyName2, value);
        this.ensureMixinType(this.n2, this.mixReferenceable);
        this.superuser.save();
    }

    public void testInnerJoin1() throws RepositoryException {
        EquiJoinCondition c = this.qf.equiJoinCondition("left", this.propertyName1, "right", this.propertyName2);
        QueryObjectModel qom = this.createQuery("jcr.join.type.inner", (JoinCondition)c);
        this.checkQOM(qom, new Node[][]{{this.n1, this.n2}, {this.n2, this.n2}});
    }

    public void testInnerJoin2() throws RepositoryException {
        EquiJoinCondition c = this.qf.equiJoinCondition("left", this.propertyName2, "right", this.propertyName1);
        QueryObjectModel qom = this.createQuery("jcr.join.type.inner", (JoinCondition)c);
        this.checkQOM(qom, new Node[][]{{this.n2, this.n1}, {this.n2, this.n2}});
    }

    public void testRightOuterJoin1() throws RepositoryException {
        EquiJoinCondition c = this.qf.equiJoinCondition("left", this.propertyName1, "right", this.propertyName2);
        QueryObjectModel qom = this.createQuery("jcr.join.type.right.outer", (JoinCondition)c);
        this.checkQOM(qom, new Node[][]{{null, this.n1}, {this.n1, this.n2}, {this.n2, this.n2}});
    }

    public void testRightOuterJoin2() throws RepositoryException {
        EquiJoinCondition c = this.qf.equiJoinCondition("left", this.propertyName2, "right", this.propertyName1);
        QueryObjectModel qom = this.createQuery("jcr.join.type.right.outer", (JoinCondition)c);
        this.checkQOM(qom, new Node[][]{{this.n2, this.n1}, {this.n2, this.n2}});
    }

    public void testLeftOuterJoin1() throws RepositoryException {
        EquiJoinCondition c = this.qf.equiJoinCondition("left", this.propertyName1, "right", this.propertyName2);
        QueryObjectModel qom = this.createQuery("jcr.join.type.left.outer", (JoinCondition)c);
        this.checkQOM(qom, new Node[][]{{this.n1, this.n2}, {this.n2, this.n2}});
    }

    public void testLeftOuterJoin2() throws RepositoryException {
        EquiJoinCondition c = this.qf.equiJoinCondition("left", this.propertyName2, "right", this.propertyName1);
        QueryObjectModel qom = this.createQuery("jcr.join.type.left.outer", (JoinCondition)c);
        this.checkQOM(qom, new Node[][]{{this.n1, null}, {this.n2, this.n1}, {this.n2, this.n2}});
    }
}

