/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.query.qom;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.EquiJoinCondition;
import javax.jcr.query.qom.JoinCondition;
import javax.jcr.query.qom.Ordering;
import javax.jcr.query.qom.QueryObjectModel;
import org.apache.jackrabbit.test.api.query.qom.AbstractJoinTest;

public class OrderingTest
extends AbstractJoinTest {
    private Node n1;
    private Node n2;

    protected void setUp() throws Exception {
        super.setUp();
        String value = "a";
        this.n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.n1.setProperty(this.propertyName1, value);
        this.n1.setProperty(this.propertyName2, "b");
        this.n2 = this.n1.addNode(this.nodeName2, this.testNodeType);
        this.n2.setProperty(this.propertyName1, value);
        this.n2.setProperty(this.propertyName2, value);
        this.superuser.save();
    }

    public void testMultipleSelectors() throws RepositoryException {
        Ordering[] orderings = new Ordering[]{this.qf.ascending((DynamicOperand)this.qf.propertyValue("left", this.propertyName2))};
        QueryObjectModel qom = this.createQuery(orderings);
        this.checkResultOrder(qom, SELECTOR_NAMES, (Node[][])new Node[][]{{this.n2, this.n2}, {this.n1, this.n2}});
        orderings[0] = this.qf.descending((DynamicOperand)this.qf.propertyValue("left", this.propertyName2));
        qom = this.createQuery(orderings);
        this.checkResultOrder(qom, SELECTOR_NAMES, (Node[][])new Node[][]{{this.n1, this.n2}, {this.n2, this.n2}});
    }

    protected QueryObjectModel createQuery(Ordering[] orderings) throws RepositoryException {
        EquiJoinCondition c = this.qf.equiJoinCondition("left", this.propertyName1, "right", this.propertyName2);
        QueryObjectModel qom = this.createQuery("jcr.join.type.inner", (JoinCondition)c);
        return this.qf.createQuery(qom.getSource(), qom.getConstraint(), orderings, qom.getColumns());
    }
}

