/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.version;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.Version;
import javax.jcr.version.VersionManager;
import org.apache.jackrabbit.test.api.version.AbstractVersionTest;

public class ConfigurationsTest
extends AbstractVersionTest {
    private VersionManager vm;
    private static String PREFIX = "/jcr:system/jcr:configurations/";
    private String ntConfiguration;
    private Node versionableNode2;

    protected void setUp() throws Exception {
        super.setUp();
        this.checkSupportedOption("option.baselines.supported");
        this.vm = this.superuser.getWorkspace().getVersionManager();
        this.versionableNode2 = this.createVersionableNode(this.testRootNode, this.nodeName4, this.versionableNodeType);
        this.ntConfiguration = this.superuser.getNamespacePrefix("http://www.jcp.org/jcr/nt/1.0") + ":configuration";
    }

    protected void tearDown() throws Exception {
        if (this.versionableNode != null) {
            this.removeConfiguration(this.versionableNode);
        }
        this.removeConfiguration(this.versionableNode2);
        this.versionableNode2.remove();
        super.tearDown();
    }

    private void removeConfiguration(Node node) throws RepositoryException {
        if (node.hasProperty("jcr:configuration")) {
            node.getProperty("jcr:configuration").getNode().remove();
        }
    }

    public void testCreateConfiguration() throws Exception {
        Node config = this.vm.createConfiguration(this.versionableNode.getPath());
        ConfigurationsTest.assertNotNull((Object)config);
        NodeType nt = config.getPrimaryNodeType();
        ConfigurationsTest.assertTrue((String)"created node must be subtype of nt:configuration", (boolean)nt.isNodeType(this.ntConfiguration));
        ConfigurationsTest.assertTrue((String)"jcr:root property of the configuration must reference the versionable node", (boolean)config.getProperty("jcr:root").getNode().isSame((Item)this.versionableNode));
        ConfigurationsTest.assertTrue((String)"jcr:configuration property of the versionable node must reference the configuration", (boolean)this.versionableNode.getProperty("jcr:configuration").getNode().isSame((Item)config));
    }

    public void testCreateConfigurationNotVersionableFails() throws Exception {
        try {
            this.vm.createConfiguration(this.nonVersionableNode.getPath());
            ConfigurationsTest.fail((String)"Create configuration must fail for non-versionable node");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testCreateConfigurationTwiceFails() throws Exception {
        this.vm.createConfiguration(this.versionableNode.getPath());
        try {
            this.vm.createConfiguration(this.versionableNode.getPath());
            ConfigurationsTest.fail((String)"Create configuration must fail if versionable is already a configuration");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testConfigurationsPath() throws Exception {
        Node config = this.vm.createConfiguration(this.versionableNode.getPath());
        ConfigurationsTest.assertNotNull((Object)config);
        NodeType nt = config.getPrimaryNodeType();
        ConfigurationsTest.assertTrue((String)"created node must be subtype of nt:configuration", (boolean)nt.isNodeType(this.ntConfiguration));
        ConfigurationsTest.assertTrue((String)("path for configuration must be below " + PREFIX + ", but was " + config.getPath()), (boolean)config.getPath().startsWith(PREFIX));
    }

    public void testCheckinConfigFailsWithUnversionedChild() throws Exception {
        Node config = this.vm.createConfiguration(this.versionableNode.getPath());
        try {
            this.vm.checkin(config.getPath());
            ConfigurationsTest.fail((String)"Checkin configuration must fail one of the recorded versions is not versioned.");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testCheckinConfig() throws Exception {
        this.vm.checkin(this.versionableNode.getPath());
        Node config = this.vm.createConfiguration(this.versionableNode.getPath());
        this.vm.checkin(config.getPath());
    }

    public void testCreateConfigWithBaseline() throws Exception {
        String path = this.versionableNode.getPath();
        Version baseVersion = this.vm.checkin(path);
        Node config = this.vm.createConfiguration(path);
        Version baseline = this.vm.checkin(config.getPath());
        this.removeConfiguration(this.versionableNode);
        this.versionableNode.remove();
        this.versionableNode = null;
        this.testRootNode.getSession().save();
        this.vm.restore(path, baseline, true);
        this.versionableNode = this.testRootNode.getSession().getNode(path);
        Version baseVersion2 = this.vm.getBaseVersion(this.versionableNode.getPath());
        ConfigurationsTest.assertTrue((String)"restored node must have former base version.", (boolean)baseVersion.isSame((Item)baseVersion2));
        config = this.versionableNode.getProperty("jcr:configuration").getNode();
        ConfigurationsTest.assertTrue((String)"Baseversion of restored config must be given baseline.", (boolean)this.vm.getBaseVersion(config.getPath()).isSame((Item)baseline));
    }

    public void testCreateConfigWithNonExistentParentFails() throws Exception {
        String path = this.versionableNode.getPath();
        this.vm.checkin(path);
        Node config = this.vm.createConfiguration(path);
        Version baseline = this.vm.checkin(config.getPath());
        this.removeConfiguration(this.versionableNode);
        this.versionableNode.remove();
        this.versionableNode = null;
        this.testRootNode.getSession().save();
        try {
            this.vm.restore("/non/existent/parent", baseline, true);
            ConfigurationsTest.fail((String)"Create configuration must fail if parent does not exist.");
        }
        catch (RepositoryException e) {
            // empty catch block
        }
    }

    public void testCreateConfigWithExistentConfigFromBaselineFails() throws Exception {
        String path = this.versionableNode.getPath();
        this.vm.checkin(path);
        Node config = this.vm.createConfiguration(path);
        Version baseline = this.vm.checkin(config.getPath());
        try {
            this.vm.restore(this.testRoot + "/nonExisting", baseline, true);
            ConfigurationsTest.fail((String)"Create configuration must fail if config recorded in baseline already exists.");
        }
        catch (RepositoryException e) {
            // empty catch block
        }
    }

    public void testRestoreBaseline() throws Exception {
        String path = this.versionableNode.getPath();
        Version bv1 = this.vm.checkpoint(path);
        Node config = this.vm.createConfiguration(path);
        Version bl1 = this.vm.checkpoint(config.getPath());
        Version bv2 = this.vm.checkpoint(path);
        Version bl2 = this.vm.checkpoint(config.getPath());
        this.vm.restore(bl1, true);
        Version bv = this.vm.getBaseVersion(path);
        ConfigurationsTest.assertTrue((String)"restored node must have former base version V1.0.", (boolean)bv.isSame((Item)bv1));
        this.vm.restore(bl2, true);
        bv = this.vm.getBaseVersion(path);
        ConfigurationsTest.assertTrue((String)"restored node must have former base version V1.1.", (boolean)bv.isSame((Item)bv2));
    }

    public void testRestoreConfig() throws Exception {
        String path = this.versionableNode.getPath();
        Version bv1 = this.vm.checkpoint(path);
        Node config = this.vm.createConfiguration(path);
        String configPath = config.getPath();
        Version bl1 = this.vm.checkpoint(config.getPath());
        Version bv2 = this.vm.checkpoint(path);
        Version bl2 = this.vm.checkpoint(config.getPath());
        this.vm.restore(configPath, bl1.getName(), true);
        Version bv = this.vm.getBaseVersion(path);
        ConfigurationsTest.assertTrue((String)"restored node must have former base version V1.0.", (boolean)bv.isSame((Item)bv1));
        this.vm.restore(configPath, bl2.getName(), true);
        bv = this.vm.getBaseVersion(path);
        ConfigurationsTest.assertTrue((String)"restored node must have former base version V1.1.", (boolean)bv.isSame((Item)bv2));
    }
}

