/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.test.api.AbstractPropertyTest;
import org.apache.jackrabbit.test.api.PropertyUtil;

public class NamePropertyTest
extends AbstractPropertyTest {
    protected int getPropertyType() {
        return 7;
    }

    protected Boolean getPropertyIsMultivalued() {
        return null;
    }

    public void testGetString() throws RepositoryException {
        Value val = PropertyUtil.getValue(this.prop);
        NamePropertyTest.assertTrue((String)("Not a valid Name property: " + this.prop.getName()), (boolean)PropertyUtil.checkNameFormat(val.getString(), this.session));
    }

    public void testGetBoolean() throws RepositoryException {
        try {
            Value val = PropertyUtil.getValue(this.prop);
            val.getBoolean();
            NamePropertyTest.fail((String)"Conversion from a Name value to a Boolean value should throw a ValueFormatException.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testGetDate() throws RepositoryException {
        try {
            Value val = PropertyUtil.getValue(this.prop);
            val.getDate();
            NamePropertyTest.fail((String)"Conversion from a Name value to a Date value should throw a ValueFormatException.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testGetDouble() throws RepositoryException {
        try {
            Value val = PropertyUtil.getValue(this.prop);
            val.getDouble();
            NamePropertyTest.fail((String)"Conversion from a Name value to a Double value should throw a ValueFormatException.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testGetLong() throws RepositoryException {
        try {
            Value val = PropertyUtil.getValue(this.prop);
            val.getLong();
            NamePropertyTest.fail((String)"Conversion from a Name value to a Long value should throw a ValueFormatException.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testGetType() throws RepositoryException {
        NamePropertyTest.assertTrue((String)"Value.getType() returns wrong type.", (boolean)PropertyUtil.checkGetType(this.prop, 7));
    }

    public void testGetNode() throws RepositoryException {
        if (!this.multiple) {
            String path = this.prop.getString();
            if (this.prop.getParent().hasNode(path)) {
                Node n = this.prop.getNode();
                NamePropertyTest.assertEquals((String)"The name of the dereferenced property must be equal to the value", (String)path, (String)n.getName());
            } else {
                try {
                    this.prop.getNode();
                    NamePropertyTest.fail((String)"Calling Property.getNode() for a NAME value that doesn't have a corresponding Node, ItemNotFoundException is expected");
                }
                catch (ItemNotFoundException itemNotFoundException) {}
            }
        } else {
            try {
                this.prop.getNode();
                NamePropertyTest.fail((String)"Property.getNode() called on a multivalue property should throw a ValueFormatException.");
            }
            catch (ValueFormatException valueFormatException) {
                // empty catch block
            }
        }
    }

    public void testGetProperty() throws RepositoryException {
        if (!this.multiple) {
            String path = this.prop.getString();
            if (this.prop.getParent().hasProperty(path)) {
                Property p = this.prop.getProperty();
                NamePropertyTest.assertEquals((String)"The name of the dereferenced property must be equal to the value", (String)path, (String)p.getName());
            } else {
                try {
                    this.prop.getProperty();
                    NamePropertyTest.fail((String)"Calling Property.getProperty() for a NAME value that doesn't have a corresponding Node, ItemNotFoundException is expected");
                }
                catch (ItemNotFoundException itemNotFoundException) {}
            }
        } else {
            try {
                this.prop.getProperty();
                NamePropertyTest.fail((String)"Property.getNode() called on a multivalue property should throw a ValueFormatException.");
            }
            catch (ValueFormatException valueFormatException) {
                // empty catch block
            }
        }
    }
}

