/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.Node;
import javax.jcr.Value;
import org.apache.jackrabbit.test.AbstractJCRTest;

public class SetPropertyBooleanTest
extends AbstractJCRTest {
    private Node testNode;

    protected void setUp() throws Exception {
        super.setUp();
        this.testNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
    }

    protected void tearDown() throws Exception {
        this.testNode = null;
        super.tearDown();
    }

    public void testNewBooleanPropertySession() throws Exception {
        this.testNode.setProperty(this.propertyName1, true);
        this.superuser.save();
        SetPropertyBooleanTest.assertEquals((String)"Setting property with Node.setProperty(String, boolean) and Session.save() not working", (boolean)true, (boolean)this.testNode.getProperty(this.propertyName1).getBoolean());
    }

    public void testModifyBooleanPropertySession() throws Exception {
        this.testNode.setProperty(this.propertyName1, true);
        this.superuser.save();
        this.testNode.setProperty(this.propertyName1, false);
        this.superuser.save();
        SetPropertyBooleanTest.assertEquals((String)"Modifying property with Node.setProperty(String, boolean) and Session.save() not working", (boolean)false, (boolean)this.testNode.getProperty(this.propertyName1).getBoolean());
    }

    public void testNewBooleanPropertyParent() throws Exception {
        this.testNode.setProperty(this.propertyName1, true);
        this.testRootNode.save();
        SetPropertyBooleanTest.assertEquals((String)"Setting property with Node.setProperty(String, boolean) and parentNode.save() not working", (boolean)true, (boolean)this.testNode.getProperty(this.propertyName1).getBoolean());
    }

    public void testModifyBooleanPropertyParent() throws Exception {
        this.testNode.setProperty(this.propertyName1, true);
        this.testRootNode.save();
        this.testNode.setProperty(this.propertyName1, false);
        this.testRootNode.save();
        SetPropertyBooleanTest.assertEquals((String)"Modifying property with Node.setProperty(String, boolean) and parentNode.save() not working", (boolean)false, (boolean)this.testNode.getProperty(this.propertyName1).getBoolean());
    }

    public void testRemoveBooleanPropertySession() throws Exception {
        this.testNode.setProperty(this.propertyName1, true);
        this.superuser.save();
        this.testNode.setProperty(this.propertyName1, (Value)null);
        this.superuser.save();
        SetPropertyBooleanTest.assertFalse((String)"Removing boolean property with Node.setProperty(String, null) and Session.save() not working", (boolean)this.testNode.hasProperty(this.propertyName1));
    }

    public void testRemoveBooleanPropertyParent() throws Exception {
        this.testNode.setProperty(this.propertyName1, true);
        this.testRootNode.save();
        this.testNode.setProperty(this.propertyName1, (Value)null);
        this.testRootNode.save();
        SetPropertyBooleanTest.assertFalse((String)"Removing boolean property with Node.setProperty(String, null) and parentNode.save() not working", (boolean)this.testNode.hasProperty(this.propertyName1));
    }
}

