/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.Node;
import javax.jcr.Value;
import org.apache.jackrabbit.test.AbstractJCRTest;

public class SetPropertyLongTest
extends AbstractJCRTest {
    private Node testNode;
    private long l1 = 0x80000002L;
    private long l2 = -2147483800L;

    protected void setUp() throws Exception {
        super.setUp();
        this.testNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
    }

    protected void tearDown() throws Exception {
        this.testNode = null;
        super.tearDown();
    }

    public void testNewLongPropertySession() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.l1);
        this.superuser.save();
        SetPropertyLongTest.assertEquals((String)"Setting property with Node.setProperty(String, long) and Session.save() not working", (Object)new Long(this.l1), (Object)new Long(this.testNode.getProperty(this.propertyName1).getLong()));
    }

    public void testModifyLongPropertySession() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.l1);
        this.superuser.save();
        this.testNode.setProperty(this.propertyName1, this.l2);
        this.superuser.save();
        SetPropertyLongTest.assertEquals((String)"Modifying property with Node.setProperty(String, long) and Session.save() not working", (Object)new Long(this.l2), (Object)new Long(this.testNode.getProperty(this.propertyName1).getLong()));
    }

    public void testNewLongPropertyParent() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.l1);
        this.testRootNode.save();
        SetPropertyLongTest.assertEquals((String)"Setting property with Node.setProperty(String, long) and parentNode.save() not working", (Object)new Long(this.l1), (Object)new Long(this.testNode.getProperty(this.propertyName1).getLong()));
    }

    public void testModifyLongPropertyParent() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.l1);
        this.testRootNode.save();
        this.testNode.setProperty(this.propertyName1, this.l2);
        this.testRootNode.save();
        SetPropertyLongTest.assertEquals((String)"Modifying property with Node.setProperty(String, long) and parentNode.save() not working", (Object)new Long(this.l2), (Object)new Long(this.testNode.getProperty(this.propertyName1).getLong()));
    }

    public void testRemoveLongPropertySession() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.l1);
        this.superuser.save();
        this.testNode.setProperty(this.propertyName1, (Value)null);
        this.superuser.save();
        SetPropertyLongTest.assertFalse((String)"Removing long property with Node.setProperty(String, null) and Session.save() not working", (boolean)this.testNode.hasProperty(this.propertyName1));
    }

    public void testRemoveLongPropertyParent() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.l1);
        this.testRootNode.save();
        this.testNode.setProperty(this.propertyName1, (Value)null);
        this.testRootNode.save();
        SetPropertyLongTest.assertFalse((String)"Removing long property with Node.setProperty(String, null) and parentNode.save() not working", (boolean)this.testNode.hasProperty(this.propertyName1));
    }
}

