/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.nodetype.NodeTypeUtil;

public class SetValueValueFormatExceptionTest
extends AbstractJCRTest {
    public void testValue() throws NotExecutableException, RepositoryException {
        Property booleanProperty = this.createProperty(6, false);
        try {
            Value dateValue = NodeTypeUtil.getValueOfType(this.superuser, 5);
            booleanProperty.setValue(dateValue);
            SetValueValueFormatExceptionTest.fail((String)"Property.setValue(Value) must throw a ValueFormatException immediately if a conversion fails.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testValueArray() throws NotExecutableException, RepositoryException {
        Property booleanProperty = this.createProperty(6, true);
        try {
            Value[] dateValues = new Value[]{NodeTypeUtil.getValueOfType(this.superuser, 4)};
            booleanProperty.setValue(dateValues);
            SetValueValueFormatExceptionTest.fail((String)"Property.setValue(Value[]) must throw a ValueFormatException immediately if a conversion fails.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testString() throws NotExecutableException, RepositoryException {
        Property dateProperty = this.createProperty(5, false);
        try {
            dateProperty.setValue("abc");
            SetValueValueFormatExceptionTest.fail((String)"Property.setValue(String) must throw a ValueFormatException immediately if a conversion fails.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testStringArray() throws NotExecutableException, RepositoryException {
        Property dateProperty = this.createProperty(5, true);
        try {
            String[] values = new String[]{"abc"};
            dateProperty.setValue(values);
            SetValueValueFormatExceptionTest.fail((String)"Property.setValue(String[]) must throw a ValueFormatException immediately if a conversion fails.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testInputStream() throws NotExecutableException, RepositoryException {
        Property dateProperty = this.createProperty(5, false);
        try {
            byte[] bytes = new byte[]{123};
            ByteArrayInputStream value = new ByteArrayInputStream(bytes);
            dateProperty.setValue((InputStream)value);
            SetValueValueFormatExceptionTest.fail((String)"Property.setValue(InputStream) must throw a ValueFormatException immediately if a conversion fails.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testLong() throws NotExecutableException, RepositoryException {
        Property booleanProperty = this.createProperty(6, false);
        try {
            booleanProperty.setValue(123L);
            SetValueValueFormatExceptionTest.fail((String)"Property.setValue(long) must throw a ValueFormatException immediately if a conversion fails.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testDouble() throws NotExecutableException, RepositoryException {
        Property booleanProperty = this.createProperty(6, false);
        try {
            booleanProperty.setValue(1.23);
            SetValueValueFormatExceptionTest.fail((String)"Property.setValue(double) must throw a ValueFormatException immediately if a conversion fails.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testCalendar() throws NotExecutableException, RepositoryException {
        Property booleanProperty = this.createProperty(6, false);
        try {
            booleanProperty.setValue(Calendar.getInstance());
            SetValueValueFormatExceptionTest.fail((String)"Property.setValue(Calendar) must throw a ValueFormatException immediately if a conversion fails.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testBoolean() throws NotExecutableException, RepositoryException {
        Property dateProperty = this.createProperty(5, false);
        try {
            dateProperty.setValue(true);
            SetValueValueFormatExceptionTest.fail((String)"Property.setValue(boolean) must throw a ValueFormatException immediately if a conversion fails.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testNode() throws NotExecutableException, RepositoryException {
        Property booleanProperty = this.createProperty(6, false);
        try {
            Node referenceableNode = this.testRootNode.addNode(this.nodeName3, this.testNodeType);
            if (this.needsMixin(referenceableNode, this.mixReferenceable)) {
                this.ensureMixinType(referenceableNode, this.mixReferenceable);
            }
            this.testRootNode.save();
            SetValueValueFormatExceptionTest.assertTrue((String)"test node should be mix:referenceable", (boolean)referenceableNode.isNodeType(this.mixReferenceable));
            booleanProperty.setValue(referenceableNode);
            SetValueValueFormatExceptionTest.fail((String)"Property.setValue(Node) must throw a ValueFormatException immediately if the property is not of type REFERENCE.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testNodeNotReferenceable() throws NotExecutableException, RepositoryException {
        if (this.testRootNode.isNodeType(this.mixReferenceable)) {
            throw new NotExecutableException("test requires testRootNode to be non-referenceable");
        }
        Property referenceProperty = this.createProperty(9, false);
        try {
            referenceProperty.setValue(this.testRootNode);
            SetValueValueFormatExceptionTest.fail((String)"Property.setValue(Node) must throw a ValueFormatException immediately if the specified node is not referenceable.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    private Property createProperty(int propertyType, boolean multiple) throws RepositoryException, NotExecutableException {
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        if (propertyType == 9 && !n.isNodeType(this.mixReferenceable)) {
            if (!n.canAddMixin(this.mixReferenceable)) {
                throw new NotExecutableException(this.testNodeType + " does not support adding of mix:referenceable");
            }
            n.addMixin(this.mixReferenceable);
            this.testRootNode.save();
        }
        Value initValue = propertyType == 9 ? this.superuser.getValueFactory().createValue(n) : NodeTypeUtil.getValueOfType(this.superuser, propertyType);
        if (multiple) {
            Value[] initValues = new Value[]{initValue};
            if (!n.getPrimaryNodeType().canSetProperty(this.propertyName1, initValues)) {
                throw new NotExecutableException("Node type: " + this.testNodeType + " does not support a multi valued " + PropertyType.nameFromValue((int)propertyType) + " property " + "called: " + this.propertyName1);
            }
            return n.setProperty(this.propertyName1, initValues);
        }
        if (!n.getPrimaryNodeType().canSetProperty(this.propertyName1, initValue)) {
            throw new NotExecutableException("Node type: " + this.testNodeType + " does not support a single valued " + PropertyType.nameFromValue((int)propertyType) + " property " + "called: " + this.propertyName1);
        }
        return n.setProperty(this.propertyName1, initValue);
    }
}

