/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.nodetype;

import java.text.ParseException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.nodetype.NodeTypeUtil;

public class CanSetPropertyLongTest
extends AbstractJCRTest {
    private Session session;

    protected void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
        this.session = this.getHelper().getReadOnlySession();
    }

    protected void tearDown() throws Exception {
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        super.tearDown();
    }

    public void testConversions() throws NotExecutableException, RepositoryException {
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.session, 3, false, false, false, false);
        if (propDef == null) {
            throw new NotExecutableException("No long property def that meets the requirements of the test has been found");
        }
        NodeType nodeType = propDef.getDeclaringNodeType();
        Value anyStringValue = NodeTypeUtil.getValueOfType(this.session, 1);
        CanSetPropertyLongTest.assertFalse((String)"canSetProperty(String propertyName, Value value) must return false if the property is of type Long and value is a StringValue that is not convertible to a LongValue", (boolean)nodeType.canSetProperty(propDef.getName(), anyStringValue));
        Value longStringValue = this.superuser.getValueFactory().createValue(NodeTypeUtil.getValueOfType(this.session, 3).getString());
        CanSetPropertyLongTest.assertTrue((String)"canSetProperty(String propertyName, Value value) must return true if the property is of type Long and value is a StringValue that is convertible to a LongValue", (boolean)nodeType.canSetProperty(propDef.getName(), longStringValue));
        Value anyBinaryValue = NodeTypeUtil.getValueOfType(this.session, 2);
        CanSetPropertyLongTest.assertFalse((String)"canSetProperty(String propertyName, Value value) must return false if the property is of type Long and value is a UTF-8 BinaryValue that is not convertible to a LongValue", (boolean)nodeType.canSetProperty(propDef.getName(), anyBinaryValue));
        Value longBinaryValue = this.superuser.getValueFactory().createValue(NodeTypeUtil.getValueOfType(this.session, 3).getString(), 2);
        CanSetPropertyLongTest.assertTrue((String)"canSetProperty(String propertyName, Value value) must return true if the property is of type Long and value is a UTF-8 BinaryValue that is convertible to a LongValue", (boolean)nodeType.canSetProperty(propDef.getName(), longBinaryValue));
        Value dateValue = NodeTypeUtil.getValueOfType(this.session, 5);
        CanSetPropertyLongTest.assertTrue((String)"canSetProperty(String propertyName, Value value) must return true if the property is of type Long and value is a DateValue", (boolean)nodeType.canSetProperty(propDef.getName(), dateValue));
        Value doubleValue = NodeTypeUtil.getValueOfType(this.session, 4);
        CanSetPropertyLongTest.assertTrue((String)"canSetProperty(String propertyName, Value value) must return true if the property is of type Long and value is a DoubleValue", (boolean)nodeType.canSetProperty(propDef.getName(), doubleValue));
        Value longValue = NodeTypeUtil.getValueOfType(this.session, 3);
        CanSetPropertyLongTest.assertTrue((String)"canSetProperty(String propertyName, Value value) must return true if the property is of type Long and value is a LongValue", (boolean)nodeType.canSetProperty(propDef.getName(), longValue));
        Value booleanValue = NodeTypeUtil.getValueOfType(this.session, 6);
        CanSetPropertyLongTest.assertFalse((String)"canSetProperty(String propertyName, Value value) must return false if the property is of type Long and value is a BooleanValue", (boolean)nodeType.canSetProperty(propDef.getName(), booleanValue));
        Value nameValue = NodeTypeUtil.getValueOfType(this.session, 7);
        CanSetPropertyLongTest.assertFalse((String)"canSetProperty(String propertyName, Value value) must return false if the property is of type Long and value is a NameValue", (boolean)nodeType.canSetProperty(propDef.getName(), nameValue));
        Value pathValue = NodeTypeUtil.getValueOfType(this.session, 8);
        CanSetPropertyLongTest.assertFalse((String)"canSetProperty(String propertyName, Value value) must return false if the property is of type Long and value is a PathValue", (boolean)nodeType.canSetProperty(propDef.getName(), pathValue));
    }

    public void testConversionsMultiple() throws NotExecutableException, RepositoryException {
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.session, 3, true, false, false, false);
        if (propDef == null) {
            throw new NotExecutableException("No multiple long property def that meets the requirements of the test has been found");
        }
        NodeType nodeType = propDef.getDeclaringNodeType();
        Value longValue = NodeTypeUtil.getValueOfType(this.superuser, 3);
        Value anyStringValue = NodeTypeUtil.getValueOfType(this.superuser, 1);
        Value[] anyStringValues = new Value[]{longValue, anyStringValue};
        CanSetPropertyLongTest.assertFalse((String)"canSetProperty(String propertyName, Value[] values) must return false if the property is of type Long and values are of type StringValue that are not convertible to LongValues", (boolean)nodeType.canSetProperty(propDef.getName(), anyStringValues));
        Value longStringValue = this.superuser.getValueFactory().createValue(NodeTypeUtil.getValueOfType(this.superuser, 3).getString());
        Value[] longStringValues = new Value[]{longStringValue};
        CanSetPropertyLongTest.assertTrue((String)"canSetProperty(String propertyName, Value[] values) must return true if the property is of type Long and values are of type StringValue that are convertible to LongValues", (boolean)nodeType.canSetProperty(propDef.getName(), longStringValues));
        Value anyBinaryValue = NodeTypeUtil.getValueOfType(this.superuser, 2);
        Value[] anyBinaryValues = new Value[]{longValue, anyBinaryValue};
        CanSetPropertyLongTest.assertFalse((String)"canSetProperty(String propertyName, Value[] values) must return false if the property is of type Long and values are of type BinaryValue that are not convertible to LongValues", (boolean)nodeType.canSetProperty(propDef.getName(), anyBinaryValues));
        Value longBinaryValue = this.superuser.getValueFactory().createValue(NodeTypeUtil.getValueOfType(this.superuser, 3).getString(), 2);
        Value[] longBinaryValues = new Value[]{longBinaryValue};
        CanSetPropertyLongTest.assertTrue((String)"canSetProperty(String propertyName, Value[] values) must return true if the property is of type Long and values are of type BinaryValue that are convertible to LongValues", (boolean)nodeType.canSetProperty(propDef.getName(), longBinaryValues));
        Value dateValue = NodeTypeUtil.getValueOfType(this.superuser, 5);
        Value[] dateValues = new Value[]{dateValue};
        CanSetPropertyLongTest.assertTrue((String)"canSetProperty(String propertyName, Value[] values) must return true if the property is of type Long and values are of type DateValue", (boolean)nodeType.canSetProperty(propDef.getName(), dateValues));
        Value doubleValue = NodeTypeUtil.getValueOfType(this.superuser, 4);
        Value[] doubleValues = new Value[]{doubleValue};
        CanSetPropertyLongTest.assertTrue((String)"canSetProperty(String propertyName, Value[] values) must return true if the property is of type Long and values are of type DoubleValue", (boolean)nodeType.canSetProperty(propDef.getName(), doubleValues));
        Value[] longValues = new Value[]{longValue};
        CanSetPropertyLongTest.assertTrue((String)"canSetProperty(String propertyName, Value[] values) must return true if the property is of type Long and values are of type LongValue", (boolean)nodeType.canSetProperty(propDef.getName(), longValues));
        Value booleanValue = NodeTypeUtil.getValueOfType(this.superuser, 6);
        Value[] booleanValues = new Value[]{longValue, booleanValue};
        CanSetPropertyLongTest.assertFalse((String)"canSetProperty(String propertyName, Value[] values) must return false if the property is of type Long and values are of type BooleanValue", (boolean)nodeType.canSetProperty(propDef.getName(), booleanValues));
        Value nameValue = NodeTypeUtil.getValueOfType(this.superuser, 7);
        Value[] nameValues = new Value[]{longValue, nameValue};
        CanSetPropertyLongTest.assertFalse((String)"canSetProperty(String propertyName, Value[] values) must return false if the property is of type Long and values are of type NameValue", (boolean)nodeType.canSetProperty(propDef.getName(), nameValues));
        Value pathValue = NodeTypeUtil.getValueOfType(this.superuser, 8);
        Value[] pathValues = new Value[]{longValue, pathValue};
        CanSetPropertyLongTest.assertFalse((String)"canSetProperty(String propertyName, Value[] values) must return false if the property is of type Long and values are of type PathValue", (boolean)nodeType.canSetProperty(propDef.getName(), pathValues));
    }

    public void testValueConstraintNotSatisfied() throws NotExecutableException, ParseException, RepositoryException {
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.session, 3, false, false, true, false);
        if (propDef == null) {
            throw new NotExecutableException("No long property def with testable value constraints has been found");
        }
        Value value = NodeTypeUtil.getValueAccordingToValueConstraints(this.superuser, propDef, false);
        if (value == null) {
            throw new NotExecutableException("No long property def with testable value constraints has been found");
        }
        NodeType nodeType = propDef.getDeclaringNodeType();
        CanSetPropertyLongTest.assertFalse((String)"canSetProperty(String propertyName, Value value) must return false if value does not match the value constraints.", (boolean)nodeType.canSetProperty(propDef.getName(), value));
    }

    public void testValueConstraintNotSatisfiedMultiple() throws NotExecutableException, ParseException, RepositoryException {
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.session, 3, true, false, true, false);
        if (propDef == null) {
            throw new NotExecutableException("No multiple long property def with testable value constraints has been found");
        }
        Value value = NodeTypeUtil.getValueAccordingToValueConstraints(this.superuser, propDef, false);
        if (value == null) {
            throw new NotExecutableException("No multiple long property def with testable value constraints has been found");
        }
        NodeType nodeType = propDef.getDeclaringNodeType();
        Value[] values = new Value[]{value};
        CanSetPropertyLongTest.assertFalse((String)"canSetProperty(String propertyName, Value[] values) must return false if values do not match the value constraints.", (boolean)nodeType.canSetProperty(propDef.getName(), values));
    }
}

