/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.nodetype;

import java.text.ParseException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.nodetype.NodeTypeUtil;

public class CanSetPropertyPathTest
extends AbstractJCRTest {
    private Session session;

    protected void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
        this.session = this.getHelper().getReadOnlySession();
    }

    protected void tearDown() throws Exception {
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        super.tearDown();
    }

    public void testConversions() throws NotExecutableException, RepositoryException {
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.session, 8, false, false, false, false);
        if (propDef == null) {
            throw new NotExecutableException("No path property def that meets the requirements of the test has been found");
        }
        NodeType nodeType = propDef.getDeclaringNodeType();
        Value pathStringValue = this.superuser.getValueFactory().createValue("abc");
        CanSetPropertyPathTest.assertTrue((String)"canSetProperty(String propertyName, Value value) must return true if the property is of type Path and value is a StringValue that is convertible to a PathValue", (boolean)nodeType.canSetProperty(propDef.getName(), pathStringValue));
        Value noPathStringValue = this.superuser.getValueFactory().createValue("a:b:c");
        CanSetPropertyPathTest.assertFalse((String)"canSetProperty(String propertyName, Value value) must return false if the property is of type Path and value is a StringValue that is not convertible to a PathValue", (boolean)nodeType.canSetProperty(propDef.getName(), noPathStringValue));
        Value pathBinaryValue = this.superuser.getValueFactory().createValue("abc", 2);
        CanSetPropertyPathTest.assertTrue((String)"canSetProperty(String propertyName, Value value) must return true if the property is of type Path and value is a UTF-8 BinaryValue that is convertible to a PathValue", (boolean)nodeType.canSetProperty(propDef.getName(), pathBinaryValue));
        Value noPathBinaryValue = this.superuser.getValueFactory().createValue("a:b:c", 2);
        CanSetPropertyPathTest.assertFalse((String)"canSetProperty(String propertyName, Value value) must return false if the property is of type Path and value is a BinaryValuethat is not convertible to a PathValue", (boolean)nodeType.canSetProperty(propDef.getName(), noPathBinaryValue));
        Value dateValue = NodeTypeUtil.getValueOfType(this.superuser, 5);
        CanSetPropertyPathTest.assertFalse((String)"canSetProperty(String propertyName, Value value) must return false if the property is of type Path and value is a DateValue", (boolean)nodeType.canSetProperty(propDef.getName(), dateValue));
        Value doubleValue = NodeTypeUtil.getValueOfType(this.superuser, 4);
        CanSetPropertyPathTest.assertFalse((String)"canSetProperty(String propertyName, Value value) must return false if the property is of type Path and value is a DoubleValue", (boolean)nodeType.canSetProperty(propDef.getName(), doubleValue));
        Value longValue = NodeTypeUtil.getValueOfType(this.superuser, 3);
        CanSetPropertyPathTest.assertFalse((String)"canSetProperty(String propertyName, Value value) must return false if the property is of type Path and value is a LongValue", (boolean)nodeType.canSetProperty(propDef.getName(), longValue));
        Value booleanValue = NodeTypeUtil.getValueOfType(this.superuser, 6);
        CanSetPropertyPathTest.assertFalse((String)"canSetProperty(String propertyName, Value value) must return false if the property is of type Path and value is a BooleanValue", (boolean)nodeType.canSetProperty(propDef.getName(), booleanValue));
        Value pathValue = NodeTypeUtil.getValueOfType(this.superuser, 7);
        CanSetPropertyPathTest.assertTrue((String)"canSetProperty(String propertyName, Value value) must return true if the property is of type Path and value is a NameValue", (boolean)nodeType.canSetProperty(propDef.getName(), pathValue));
        Value relPathValue = this.superuser.getValueFactory().createValue("abc", 8);
        CanSetPropertyPathTest.assertTrue((String)"canSetProperty(String propertyName, Value value) must return true if the property is of type Path and value is a PathValue", (boolean)nodeType.canSetProperty(propDef.getName(), relPathValue));
        Value absPathValue = this.superuser.getValueFactory().createValue("/abc", 8);
        CanSetPropertyPathTest.assertTrue((String)"canSetProperty(String propertyName, Value value) must return true if the property is of type Path and value is a PathValue", (boolean)nodeType.canSetProperty(propDef.getName(), absPathValue));
    }

    public void testConversionsMultiple() throws NotExecutableException, RepositoryException {
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.session, 8, true, false, false, false);
        if (propDef == null) {
            throw new NotExecutableException("No multiple path property def that meets the requirements of the test has been found");
        }
        NodeType nodeType = propDef.getDeclaringNodeType();
        Value pathValue = NodeTypeUtil.getValueOfType(this.superuser, 8);
        Value pathStringValue = this.superuser.getValueFactory().createValue("abc");
        Value[] pathStringValues = new Value[]{pathStringValue};
        CanSetPropertyPathTest.assertTrue((String)"canSetProperty(String propertyName, Value[] values) must return true if the property is of type Path and values are of type StringValue that are convertible to PathValues", (boolean)nodeType.canSetProperty(propDef.getName(), pathStringValues));
        Value notPathStringValue = this.superuser.getValueFactory().createValue("a:b:c");
        Value[] notPathStringValues = new Value[]{pathValue, notPathStringValue};
        CanSetPropertyPathTest.assertFalse((String)"canSetProperty(String propertyName, Value[] values) must return false if the property is of type Path and values are of type StringValue that are not convertible to PathValues ", (boolean)nodeType.canSetProperty(propDef.getName(), notPathStringValues));
        Value pathBinaryValue = this.superuser.getValueFactory().createValue("abc", 2);
        Value[] pathBinaryValues = new Value[]{pathBinaryValue};
        CanSetPropertyPathTest.assertTrue((String)"canSetProperty(String propertyName, Value[] values) must return true if the property is of type Path and values are of type BinaryValue that are convertible to PathValues", (boolean)nodeType.canSetProperty(propDef.getName(), pathBinaryValues));
        Value notPathBinaryValue = this.superuser.getValueFactory().createValue("a:b:c", 2);
        Value[] notPathBinaryValues = new Value[]{pathValue, notPathBinaryValue};
        CanSetPropertyPathTest.assertFalse((String)"canSetProperty(String propertyName, Value[] values) must return false if the property is of type Path and values are of type BinaryValue that are not convertible to PathValues", (boolean)nodeType.canSetProperty(propDef.getName(), notPathBinaryValues));
        Value dateValue = NodeTypeUtil.getValueOfType(this.superuser, 5);
        Value[] dateValues = new Value[]{pathValue, dateValue};
        CanSetPropertyPathTest.assertFalse((String)"canSetProperty(String propertyName, Value[] values) must return false if the property is of type Path and values are of type DateValue", (boolean)nodeType.canSetProperty(propDef.getName(), dateValues));
        Value doubleValue = NodeTypeUtil.getValueOfType(this.superuser, 4);
        Value[] doubleValues = new Value[]{pathValue, doubleValue};
        CanSetPropertyPathTest.assertFalse((String)"canSetProperty(String propertyName, Value[] values) must return false if the property is of type Path and values are of type DoubleValue", (boolean)nodeType.canSetProperty(propDef.getName(), doubleValues));
        Value longValue = NodeTypeUtil.getValueOfType(this.superuser, 3);
        Value[] longValues = new Value[]{pathValue, longValue};
        CanSetPropertyPathTest.assertFalse((String)"canSetProperty(String propertyName, Value[] values) must return false if the property is of type Path and values are of type LongValue", (boolean)nodeType.canSetProperty(propDef.getName(), longValues));
        Value booleanValue = NodeTypeUtil.getValueOfType(this.superuser, 6);
        Value[] booleanValues = new Value[]{booleanValue};
        CanSetPropertyPathTest.assertFalse((String)"canSetProperty(String propertyName, Value[] values) must return false if the property is of type Path and values are of type BooleanValue", (boolean)nodeType.canSetProperty(propDef.getName(), booleanValues));
        Value nameValue = NodeTypeUtil.getValueOfType(this.superuser, 7);
        Value[] nameValues = new Value[]{nameValue};
        CanSetPropertyPathTest.assertTrue((String)"canSetProperty(String propertyName, Value[] values) must return true if the property is of type Path and values are of type NameValue", (boolean)nodeType.canSetProperty(propDef.getName(), nameValues));
        Value[] pathValues = new Value[]{pathValue, pathValue};
        CanSetPropertyPathTest.assertTrue((String)"canSetProperty(String propertyName, Value[] values) must return true if the property is of type Path and values are of type PathValue", (boolean)nodeType.canSetProperty(propDef.getName(), pathValues));
    }

    public void testValueConstraintNotSatisfied() throws NotExecutableException, ParseException, RepositoryException {
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.session, 8, false, false, true, false);
        if (propDef == null) {
            throw new NotExecutableException("No path property def with testable value constraints has been found");
        }
        Value value = NodeTypeUtil.getValueAccordingToValueConstraints(this.superuser, propDef, false);
        if (value == null) {
            throw new NotExecutableException("No path property def with testable value constraints has been found");
        }
        NodeType nodeType = propDef.getDeclaringNodeType();
        CanSetPropertyPathTest.assertFalse((String)"canSetProperty(String propertyName, Value value) must return false if value does not match the value constraints.", (boolean)nodeType.canSetProperty(propDef.getName(), value));
    }

    public void testValueConstraintNotSatisfiedMultiple() throws NotExecutableException, ParseException, RepositoryException {
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.session, 8, true, false, true, false);
        if (propDef == null) {
            throw new NotExecutableException("No multiple path property def with testable value constraints has been found");
        }
        Value value = NodeTypeUtil.getValueAccordingToValueConstraints(this.superuser, propDef, false);
        if (value == null) {
            throw new NotExecutableException("No multiple path property def with testable value constraints has been found");
        }
        NodeType nodeType = propDef.getDeclaringNodeType();
        Value[] values = new Value[]{value};
        CanSetPropertyPathTest.assertFalse((String)"canSetProperty(String propertyName, Value[] values) must return false if values do not match the value constraints.", (boolean)nodeType.canSetProperty(propDef.getName(), values));
    }
}

