/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.observation;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventListener;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.observation.AbstractObservationTest;
import org.apache.jackrabbit.test.api.observation.EventResult;

public class AddEventListenerTest
extends AbstractObservationTest {
    public void testPath() throws RepositoryException {
        EventResult listener = new EventResult(this.log);
        this.obsMgr.addEventListener((EventListener)listener, 1, this.testRoot + "/" + this.nodeName1, true, null, null, false);
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        n.addNode(this.nodeName2, this.testNodeType);
        this.testRootNode.save();
        Event[] events = listener.getEvents(5000L);
        this.obsMgr.removeEventListener((EventListener)listener);
        this.checkNodeAdded(events, new String[]{this.nodeName1 + "/" + this.nodeName2}, null);
    }

    public void testIsDeepFalseNodeAdded() throws RepositoryException {
        EventResult listener = new EventResult(this.log);
        this.obsMgr.addEventListener((EventListener)listener, 1, this.testRoot + "/" + this.nodeName1, false, null, null, false);
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        n.addNode(this.nodeName2, this.testNodeType);
        this.testRootNode.save();
        Event[] events = listener.getEvents(5000L);
        this.obsMgr.removeEventListener((EventListener)listener);
        this.checkNodeAdded(events, new String[]{this.nodeName1 + "/" + this.nodeName2}, null);
    }

    public void testIsDeepFalsePropertyAdded() throws RepositoryException {
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        Node n2 = this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        this.testRootNode.save();
        EventResult listener = new EventResult(this.log);
        this.obsMgr.addEventListener((EventListener)listener, 4, this.testRoot + "/" + this.nodeName1, false, null, null, false);
        n1.setProperty(this.propertyName1, "foo");
        n2.setProperty(this.propertyName1, "foo");
        this.testRootNode.save();
        Event[] events = listener.getEvents(5000L);
        this.obsMgr.removeEventListener((EventListener)listener);
        this.checkPropertyAdded(events, new String[]{this.nodeName1 + "/" + this.propertyName1});
    }

    public void testNoLocalTrue() throws RepositoryException {
        EventResult listener = new EventResult(this.log);
        this.obsMgr.addEventListener((EventListener)listener, 1, this.testRoot, true, null, null, true);
        this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.testRootNode.save();
        Event[] events = listener.getEvents(5000L);
        this.obsMgr.removeEventListener((EventListener)listener);
        AddEventListenerTest.assertEquals((String)"EventListener must not receive own modification when noLocal=true", (int)0, (int)events.length);
    }

    public void testUUID() throws RepositoryException, NotExecutableException {
        Node n1 = null;
        Node n2 = null;
        try {
            n1 = this.createReferenceable(this.nodeName1, this.testNodeType);
            n2 = this.createReferenceable(this.nodeName2, this.testNodeType);
        }
        catch (RepositoryException e) {
            throw new NotExecutableException("Repository does not support mix:referenceable");
        }
        this.testRootNode.save();
        EventResult listener = new EventResult(this.log);
        this.obsMgr.addEventListener((EventListener)listener, 4, this.testRoot, true, new String[]{n1.getIdentifier()}, null, false);
        n1.setProperty(this.propertyName1, "foo");
        n2.setProperty(this.propertyName1, "foo");
        this.testRootNode.save();
        Event[] events = listener.getEvents(5000L);
        this.obsMgr.removeEventListener((EventListener)listener);
        this.checkPropertyAdded(events, new String[]{this.nodeName1 + "/" + this.propertyName1});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNodeType() throws RepositoryException {
        String nodetype2 = this.getProperty("nodetype2");
        EventResult listener = new EventResult(this.log);
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        Node n2 = this.testRootNode.addNode(this.nodeName2, nodetype2);
        this.testRootNode.save();
        this.obsMgr.addEventListener((EventListener)listener, 1, this.testRoot, true, null, new String[]{this.testNodeType}, false);
        Session s = this.getHelper().getSuperuserSession();
        try {
            Node n = (Node)s.getItem(n1.getPath());
            n.addNode(this.nodeName3, this.testNodeType);
            n = (Node)s.getItem(n2.getPath());
            n.addNode(this.nodeName3, nodetype2);
            n = (Node)s.getItem(this.testRoot);
            n.save();
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            s.logout();
            throw throwable;
        }
        s.logout();
        Event[] events = listener.getEvents(5000L);
        this.obsMgr.removeEventListener((EventListener)listener);
        this.checkNodeAdded(events, new String[]{this.nodeName1 + "/" + this.nodeName3}, null);
    }

    private Node createReferenceable(String nodeName, String nodeType) throws RepositoryException, NotExecutableException {
        Node n = this.testRootNode.addNode(nodeName, nodeType);
        this.ensureMixinType(n, this.mixReferenceable);
        this.testRootNode.save();
        return n;
    }
}

