/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.observation;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import org.apache.jackrabbit.test.api.observation.AbstractObservationTest;
import org.apache.jackrabbit.test.api.observation.EventResult;

public class NodeAddedTest
extends AbstractObservationTest {
    public void testSingleNodeAdded() throws RepositoryException {
        EventResult result = new EventResult(this.log);
        this.addEventListener(result, 1);
        this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.testRootNode.save();
        Event[] events = result.getEvents(5000L);
        this.removeEventListener(result);
        this.checkNodeAdded(events, new String[]{this.nodeName1}, null);
    }

    public void testMultipleNodeAdded1() throws RepositoryException {
        EventResult result = new EventResult(this.log);
        this.addEventListener(result, 1);
        this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        this.testRootNode.save();
        Event[] events = result.getEvents(5000L);
        this.removeEventListener(result);
        this.checkNodeAdded(events, new String[]{this.nodeName1, this.nodeName2}, null);
    }

    public void testMultipleNodeAdded2() throws RepositoryException {
        EventResult result = new EventResult(this.log);
        this.addEventListener(result, 1);
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        n1.addNode(this.nodeName2, this.testNodeType);
        this.testRootNode.save();
        Event[] events = result.getEvents(5000L);
        this.removeEventListener(result);
        this.checkNodeAdded(events, new String[]{this.nodeName1, this.nodeName1 + "/" + this.nodeName2}, null);
    }

    public void testTransientNodeAddedRemoved() throws RepositoryException {
        EventResult result = new EventResult(this.log);
        this.addEventListener(result, 1);
        this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        Node n2 = this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        n2.remove();
        this.testRootNode.save();
        Event[] events = result.getEvents(5000L);
        this.removeEventListener(result);
        this.checkNodeAdded(events, new String[]{this.nodeName1}, null);
    }
}

