/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.query.qom;

import java.math.BigDecimal;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.Source;
import javax.jcr.query.qom.StaticOperand;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.query.qom.AbstractQOMTest;

public class BindVariableValueTest
extends AbstractQOMTest {
    private static final String STRING_VALUE = "JSR";
    private static final long LONG_VALUE = 283L;
    private static final double DOUBLE_VALUE = Math.PI;
    private static final boolean BOOLEAN_VALUE = true;
    private static final Calendar DATE_VALUE = Calendar.getInstance();
    private static final BigDecimal DECIMAL_VALUE = new BigDecimal(283L);
    private static final String URI_VALUE = "http://example.com/";
    private Query qomQuery;
    private Query sqlQuery;

    protected void setUp() throws Exception {
        super.setUp();
        this.qomQuery = this.qf.createQuery((Source)this.qf.selector(this.testNodeType, "s"), (Constraint)this.qf.and((Constraint)this.qf.childNode("s", this.testRoot), (Constraint)this.qf.comparison((DynamicOperand)this.qf.propertyValue("s", this.propertyName1), "jcr.operator.equal.to", (StaticOperand)this.qf.bindVariable("v"))), null, null);
        this.sqlQuery = this.qm.createQuery(this.qomQuery.getStatement(), "JCR-SQL2");
    }

    protected void tearDown() throws Exception {
        this.qomQuery = null;
        super.tearDown();
    }

    public void testBindVariableNames() throws RepositoryException {
        String[] names = this.qomQuery.getBindVariableNames();
        BindVariableValueTest.assertNotNull((Object)names);
        BindVariableValueTest.assertEquals((int)1, (int)names.length);
        BindVariableValueTest.assertEquals((String)"v", (String)names[0]);
    }

    public void testIllegalArgumentException() throws RepositoryException {
        try {
            this.bindVariableValue(this.qomQuery, "x", this.vf.createValue(STRING_VALUE));
            BindVariableValueTest.fail((String)"Query.bindValue() must throw IllegalArgumentException for unknown variable name");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.bindVariableValue(this.sqlQuery, "x", this.vf.createValue(STRING_VALUE));
            BindVariableValueTest.fail((String)"Query.bindValue() must throw IllegalArgumentException for unknown variable name");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testString() throws RepositoryException {
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        n.setProperty(this.propertyName1, STRING_VALUE);
        this.superuser.save();
        this.bindVariableValue(this.qomQuery, "v", this.vf.createValue(STRING_VALUE));
        this.checkResult(this.qomQuery.execute(), new Node[]{n});
        this.bindVariableValue(this.sqlQuery, "v", this.vf.createValue(STRING_VALUE));
        this.checkResult(this.sqlQuery.execute(), new Node[]{n});
    }

    public void testDate() throws RepositoryException {
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        n.setProperty(this.propertyName1, DATE_VALUE);
        this.superuser.save();
        this.bindVariableValue(this.sqlQuery, "v", this.vf.createValue(DATE_VALUE));
        this.checkResult(this.sqlQuery.execute(), new Node[]{n});
        this.bindVariableValue(this.qomQuery, "v", this.vf.createValue(DATE_VALUE));
        this.checkResult(this.qomQuery.execute(), new Node[]{n});
    }

    public void testLong() throws RepositoryException {
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        n.setProperty(this.propertyName1, 283L);
        this.superuser.save();
        this.bindVariableValue(this.qomQuery, "v", this.vf.createValue(283L));
        this.checkResult(this.qomQuery.execute(), new Node[]{n});
        this.bindVariableValue(this.sqlQuery, "v", this.vf.createValue(283L));
        this.checkResult(this.sqlQuery.execute(), new Node[]{n});
    }

    public void testDouble() throws RepositoryException {
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        n.setProperty(this.propertyName1, Math.PI);
        this.superuser.save();
        this.bindVariableValue(this.qomQuery, "v", this.vf.createValue(Math.PI));
        this.checkResult(this.qomQuery.execute(), new Node[]{n});
        this.bindVariableValue(this.sqlQuery, "v", this.vf.createValue(Math.PI));
        this.checkResult(this.sqlQuery.execute(), new Node[]{n});
    }

    public void testBoolean() throws RepositoryException {
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        n.setProperty(this.propertyName1, true);
        this.superuser.save();
        this.bindVariableValue(this.qomQuery, "v", this.vf.createValue(true));
        this.checkResult(this.qomQuery.execute(), new Node[]{n});
        this.bindVariableValue(this.sqlQuery, "v", this.vf.createValue(true));
        this.checkResult(this.sqlQuery.execute(), new Node[]{n});
    }

    public void testName() throws RepositoryException {
        Value name = this.vf.createValue(STRING_VALUE, 7);
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        n.setProperty(this.propertyName1, name);
        this.superuser.save();
        this.bindVariableValue(this.qomQuery, "v", name);
        this.checkResult(this.qomQuery.execute(), new Node[]{n});
        this.bindVariableValue(this.sqlQuery, "v", name);
        this.checkResult(this.sqlQuery.execute(), new Node[]{n});
    }

    public void testPath() throws RepositoryException {
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        Value path = this.vf.createValue(n.getPath(), 8);
        n.setProperty(this.propertyName1, path);
        this.superuser.save();
        this.bindVariableValue(this.qomQuery, "v", path);
        this.checkResult(this.qomQuery.execute(), new Node[]{n});
        this.bindVariableValue(this.sqlQuery, "v", path);
        this.checkResult(this.sqlQuery.execute(), new Node[]{n});
    }

    public void testReference() throws RepositoryException, NotExecutableException {
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.superuser.save();
        this.ensureMixinType(n, this.mixReferenceable);
        this.superuser.save();
        n.setProperty(this.propertyName1, n);
        this.superuser.save();
        this.bindVariableValue(this.qomQuery, "v", this.vf.createValue(n));
        this.checkResult(this.qomQuery.execute(), new Node[]{n});
        this.bindVariableValue(this.sqlQuery, "v", this.vf.createValue(n));
        this.checkResult(this.sqlQuery.execute(), new Node[]{n});
    }

    public void testWeakReference() throws RepositoryException, NotExecutableException {
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.superuser.save();
        this.ensureMixinType(n, this.mixReferenceable);
        this.superuser.save();
        n.setProperty(this.propertyName1, this.vf.createValue(n, true));
        this.superuser.save();
        this.bindVariableValue(this.qomQuery, "v", this.vf.createValue(n, true));
        this.checkResult(this.qomQuery.execute(), new Node[]{n});
        this.bindVariableValue(this.sqlQuery, "v", this.vf.createValue(n, true));
        this.checkResult(this.sqlQuery.execute(), new Node[]{n});
    }

    public void testURI() throws RepositoryException {
        Value value = this.vf.createValue(URI_VALUE, 11);
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        n.setProperty(this.propertyName1, value);
        this.superuser.save();
        this.bindVariableValue(this.qomQuery, "v", value);
        this.checkResult(this.qomQuery.execute(), new Node[]{n});
        this.bindVariableValue(this.sqlQuery, "v", value);
        this.checkResult(this.sqlQuery.execute(), new Node[]{n});
    }

    public void testDecimal() throws RepositoryException {
        Value value = this.vf.createValue(DECIMAL_VALUE);
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        n.setProperty(this.propertyName1, value);
        this.superuser.save();
        this.bindVariableValue(this.qomQuery, "v", value);
        this.checkResult(this.qomQuery.execute(), new Node[]{n});
        this.bindVariableValue(this.sqlQuery, "v", value);
        this.checkResult(this.sqlQuery.execute(), new Node[]{n});
    }
}

