/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.query.qom;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.jcr.query.qom.Column;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.Source;
import org.apache.jackrabbit.test.api.query.qom.AbstractQOMTest;

public class RowTest
extends AbstractQOMTest {
    private static final String TEST_VALUE = "value";
    private static final String SELECTOR_NAME = "s";

    protected void setUp() throws Exception {
        super.setUp();
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        n.setProperty(this.propertyName1, TEST_VALUE);
        this.superuser.save();
    }

    public void testGetValues() throws RepositoryException {
        Row r = this.getRow();
        Value[] values = r.getValues();
        RowTest.assertEquals((String)"wrong number of columns", (int)1, (int)values.length);
        RowTest.assertEquals((String)"property value does not match", (String)TEST_VALUE, (String)values[0].getString());
    }

    public void testGetValue() throws RepositoryException {
        Row r = this.getRow();
        RowTest.assertEquals((String)"property value does not match", (String)TEST_VALUE, (String)r.getValue(this.propertyName1).getString());
    }

    public void testGetNode() throws RepositoryException {
        Row r = this.getRow();
        String expectedPath = this.testRootNode.getNode(this.nodeName1).getPath();
        RowTest.assertEquals((String)"unexpected result node", (String)expectedPath, (String)r.getNode().getPath());
    }

    public void testGetNodeWithSelector() throws RepositoryException {
        Row r = this.getRow();
        String expectedPath = this.testRootNode.getNode(this.nodeName1).getPath();
        RowTest.assertEquals((String)"unexpected result node", (String)expectedPath, (String)r.getNode(SELECTOR_NAME).getPath());
    }

    public void testGetPath() throws RepositoryException {
        Row r = this.getRow();
        String expectedPath = this.testRootNode.getNode(this.nodeName1).getPath();
        RowTest.assertEquals((String)"unexpected result node", (String)expectedPath, (String)r.getPath());
    }

    public void testGetPathWithSelector() throws RepositoryException {
        Row r = this.getRow();
        String expectedPath = this.testRootNode.getNode(this.nodeName1).getPath();
        RowTest.assertEquals((String)"unexpected result node", (String)expectedPath, (String)r.getPath(SELECTOR_NAME));
    }

    public void testGetScore() throws RepositoryException {
        Row r = this.getRow();
        r.getScore();
    }

    public void testGetScoreWithSelector() throws RepositoryException {
        Row r = this.getRow();
        r.getScore(SELECTOR_NAME);
    }

    private Row getRow() throws RepositoryException {
        QueryObjectModel qom = this.qf.createQuery((Source)this.qf.selector(this.testNodeType, SELECTOR_NAME), (Constraint)this.qf.descendantNode(SELECTOR_NAME, this.testRoot), null, new Column[]{this.qf.column(SELECTOR_NAME, this.propertyName1, this.propertyName1)});
        RowIterator rows = qom.execute().getRows();
        RowTest.assertTrue((String)"empty result", (boolean)rows.hasNext());
        Row r = rows.nextRow();
        RowTest.assertFalse((String)"result must not contain more than one row", (boolean)rows.hasNext());
        return r;
    }
}

