/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.security;

import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.security.AbstractAccessControlTest;

public class RSessionAccessControlPolicyTest
extends AbstractAccessControlTest {
    private String path;
    private Session readOnlySession;
    private AccessControlManager testAcMgr;

    protected void setUp() throws Exception {
        super.setUp();
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.superuser.save();
        this.path = n.getPath();
        this.readOnlySession = this.getHelper().getReadOnlySession();
        this.testAcMgr = RSessionAccessControlPolicyTest.getAccessControlManager(this.readOnlySession);
    }

    protected void tearDown() throws Exception {
        if (this.readOnlySession != null) {
            this.readOnlySession.logout();
        }
        super.tearDown();
    }

    public void testGetPolicy() throws RepositoryException, AccessDeniedException, NotExecutableException {
        try {
            this.testAcMgr.getPolicies(this.path);
            RSessionAccessControlPolicyTest.fail((String)"read only session may not read AC content.");
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
    }

    public void testGetEffectivePolicy() throws RepositoryException, AccessDeniedException, NotExecutableException {
        try {
            this.testAcMgr.getEffectivePolicies(this.path);
            RSessionAccessControlPolicyTest.fail((String)"read only session may not read AC content.");
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
    }

    public void testGetApplicablePolicies() throws RepositoryException, AccessDeniedException, NotExecutableException {
        try {
            this.testAcMgr.getApplicablePolicies(this.path);
            RSessionAccessControlPolicyTest.fail((String)"read only session may not read AC content.");
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
    }

    public void testSetPolicy() throws RepositoryException, AccessDeniedException, NotExecutableException {
        AccessControlPolicyIterator it = this.acMgr.getApplicablePolicies(this.path);
        if (!it.hasNext()) {
            throw new NotExecutableException();
        }
        try {
            this.testAcMgr.setPolicy(this.path, it.nextAccessControlPolicy());
            RSessionAccessControlPolicyTest.fail((String)"read only session may not modify AC content.");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    public void testSetInvalidPolicy() throws RepositoryException, AccessDeniedException, NotExecutableException {
        try {
            this.testAcMgr.setPolicy(this.path, new AccessControlPolicy(){

                public String getName() throws RepositoryException {
                    return this.getClass().getName();
                }

                public String getDescription() throws RepositoryException {
                    return "";
                }
            });
            RSessionAccessControlPolicyTest.fail((String)"Invalid policy may not be set by a READ-only session.");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }
}

