/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.version;

import javax.jcr.RepositoryException;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionManager;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.version.AbstractOnParentVersionTest;

public class OnParentVersionAbortTest
extends AbstractOnParentVersionTest {
    protected void setUp() throws Exception {
        this.OPVAction = 6;
        super.setUp();
    }

    public void testRestoreProp() throws RepositoryException {
        try {
            this.p.getParent().checkout();
            this.p.getParent().checkin();
            OnParentVersionAbortTest.fail((String)"On checkin of N which has a property with OnParentVersion ABORT defined, an UnsupportedRepositoryOperationException must be thrown.");
        }
        catch (VersionException versionException) {
            // empty catch block
        }
    }

    public void testRestorePropJcr2() throws RepositoryException {
        try {
            VersionManager versionManager = this.p.getSession().getWorkspace().getVersionManager();
            String path = this.p.getParent().getPath();
            versionManager.checkout(path);
            versionManager.checkin(path);
            OnParentVersionAbortTest.fail((String)"On checkin of N which has a property with OnParentVersion ABORT defined, an UnsupportedRepositoryOperationException must be thrown.");
        }
        catch (VersionException versionException) {
            // empty catch block
        }
    }

    public void testRestoreNode() throws RepositoryException, NotExecutableException {
        this.addChildNode(this.OPVAction);
        this.testRootNode.save();
        try {
            this.versionableNode.checkin();
            OnParentVersionAbortTest.fail((String)"On checkin of N which has a child node with OnParentVersion ABORT defined, an UnsupportedRepositoryOperationException must be thrown.");
        }
        catch (VersionException versionException) {
            // empty catch block
        }
    }

    public void testRestoreNodeJcr2() throws RepositoryException, NotExecutableException {
        this.addChildNode(this.OPVAction);
        this.testRootNode.getSession().save();
        try {
            this.versionableNode.getSession().getWorkspace().getVersionManager().checkin(this.versionableNode.getPath());
            OnParentVersionAbortTest.fail((String)"On checkin of N which has a child node with OnParentVersion ABORT defined, an UnsupportedRepositoryOperationException must be thrown.");
        }
        catch (VersionException versionException) {
            // empty catch block
        }
    }
}

