/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.nodetype;

import java.text.ParseException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.nodetype.NodeTypeUtil;

public class CanSetPropertyDoubleTest
extends AbstractJCRTest {
    private Session session;

    @Override
    protected void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
        this.session = this.getHelper().getReadOnlySession();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        super.tearDown();
    }

    public void testConversions() throws NotExecutableException, RepositoryException {
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.session, 4, false, false, false, false);
        if (propDef == null) {
            throw new NotExecutableException("No double property def that meets the requirements of the test has been found");
        }
        NodeType nodeType = propDef.getDeclaringNodeType();
        Value anyStringValue = NodeTypeUtil.getValueOfType(this.session, 1);
        CanSetPropertyDoubleTest.assertFalse((String)"canSetProperty(String propertyName, Value value) must return false if the property is of type Double and value is a StringValue that is not convertible to a DoubleValue", (boolean)nodeType.canSetProperty(propDef.getName(), anyStringValue));
        Value doubleStringValue = this.superuser.getValueFactory().createValue(NodeTypeUtil.getValueOfType(this.session, 4).getString());
        CanSetPropertyDoubleTest.assertTrue((String)"canSetProperty(String propertyName, Value value) must return true if the property is of type Double and value is a StringValue that is convertible to a DoubleValue", (boolean)nodeType.canSetProperty(propDef.getName(), doubleStringValue));
        Value anyBinaryValue = NodeTypeUtil.getValueOfType(this.session, 2);
        CanSetPropertyDoubleTest.assertFalse((String)"canSetProperty(String propertyName, Value value) must return false if the property is of type Double and value is a UTF-8 BinaryValue that is not convertible to a DoubleValue", (boolean)nodeType.canSetProperty(propDef.getName(), anyBinaryValue));
        Value doubleBinaryValue = this.superuser.getValueFactory().createValue(NodeTypeUtil.getValueOfType(this.session, 4).getString(), 2);
        CanSetPropertyDoubleTest.assertTrue((String)"canSetProperty(String propertyName, Value value) must return true if the property is of type Double and value is a UTF-8 BinaryValue that is convertible to a DoubleValue", (boolean)nodeType.canSetProperty(propDef.getName(), doubleBinaryValue));
        Value dateValue = NodeTypeUtil.getValueOfType(this.session, 5);
        CanSetPropertyDoubleTest.assertTrue((String)"canSetProperty(String propertyName, Value value) must return true if the property is of type Double and value is a DateValue", (boolean)nodeType.canSetProperty(propDef.getName(), dateValue));
        Value doubleValue = NodeTypeUtil.getValueOfType(this.session, 4);
        CanSetPropertyDoubleTest.assertTrue((String)"canSetProperty(String propertyName, Value value) must return true if the property is of type Double and value is a DoubleValue", (boolean)nodeType.canSetProperty(propDef.getName(), doubleValue));
        Value longValue = NodeTypeUtil.getValueOfType(this.session, 3);
        CanSetPropertyDoubleTest.assertTrue((String)"canSetProperty(String propertyName, Value value) must return true if the property is of type Double and value is a LongValue", (boolean)nodeType.canSetProperty(propDef.getName(), longValue));
        Value booleanValue = NodeTypeUtil.getValueOfType(this.session, 6);
        CanSetPropertyDoubleTest.assertFalse((String)"canSetProperty(String propertyName, Value value) must return false if the property is of type Double and value is a BooleanValue", (boolean)nodeType.canSetProperty(propDef.getName(), booleanValue));
        Value nameValue = NodeTypeUtil.getValueOfType(this.session, 7);
        CanSetPropertyDoubleTest.assertFalse((String)"canSetProperty(String propertyName, Value value) must return false if the property is of type Double and value is a NameValue", (boolean)nodeType.canSetProperty(propDef.getName(), nameValue));
        Value pathValue = NodeTypeUtil.getValueOfType(this.session, 8);
        CanSetPropertyDoubleTest.assertFalse((String)"canSetProperty(String propertyName, Value value) must return false if the property is of type Double and value is a PathValue", (boolean)nodeType.canSetProperty(propDef.getName(), pathValue));
    }

    public void testConversionsMultiple() throws NotExecutableException, RepositoryException {
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.session, 4, true, false, false, false);
        if (propDef == null) {
            throw new NotExecutableException("No multiple double property def that meets the requirements of the test has been found");
        }
        NodeType nodeType = propDef.getDeclaringNodeType();
        Value doubleValue = NodeTypeUtil.getValueOfType(this.session, 4);
        Value anyStringValue = NodeTypeUtil.getValueOfType(this.session, 1);
        Value[] anyStringValues = new Value[]{doubleValue, anyStringValue};
        CanSetPropertyDoubleTest.assertFalse((String)"canSetProperty(String propertyName, Value[] values) must return false if the property is of type Double and values are of type StringValue that are not convertible to DoubleValues", (boolean)nodeType.canSetProperty(propDef.getName(), anyStringValues));
        Value doubleStringValue = this.superuser.getValueFactory().createValue(NodeTypeUtil.getValueOfType(this.session, 4).getString());
        Value[] doubleStringValues = new Value[]{doubleStringValue};
        CanSetPropertyDoubleTest.assertTrue((String)"canSetProperty(String propertyName, Value[] values) must return true if the property is of type Double and values are of type StringValue that are convertible to DoubleValues", (boolean)nodeType.canSetProperty(propDef.getName(), doubleStringValues));
        Value anyBinaryValue = NodeTypeUtil.getValueOfType(this.session, 2);
        Value[] anyBinaryValues = new Value[]{doubleValue, anyBinaryValue};
        CanSetPropertyDoubleTest.assertFalse((String)"canSetProperty(String propertyName, Value[] values) must return false if the property is of type Double and values are of type BinaryValue that are not convertible to DoubleValues", (boolean)nodeType.canSetProperty(propDef.getName(), anyBinaryValues));
        Value doubleBinaryValue = this.superuser.getValueFactory().createValue(NodeTypeUtil.getValueOfType(this.session, 4).getString(), 2);
        Value[] doubleBinaryValues = new Value[]{doubleBinaryValue};
        CanSetPropertyDoubleTest.assertTrue((String)"canSetProperty(String propertyName, Value[] values) must return true if the property is of type Double and values are of type BinaryValue that are convertible to DoubleValues", (boolean)nodeType.canSetProperty(propDef.getName(), doubleBinaryValues));
        Value dateValue = NodeTypeUtil.getValueOfType(this.session, 5);
        Value[] dateValues = new Value[]{dateValue};
        CanSetPropertyDoubleTest.assertTrue((String)"canSetProperty(String propertyName, Value[] values) must return true if the property is of type Double and values are of type DateValue", (boolean)nodeType.canSetProperty(propDef.getName(), dateValues));
        Value[] doubleValues = new Value[]{doubleValue};
        CanSetPropertyDoubleTest.assertTrue((String)"canSetProperty(String propertyName, Value[] values) must return true if the property is of type Double and values are of type DoubleValue", (boolean)nodeType.canSetProperty(propDef.getName(), doubleValues));
        Value longValue = NodeTypeUtil.getValueOfType(this.session, 3);
        Value[] longValues = new Value[]{longValue};
        CanSetPropertyDoubleTest.assertTrue((String)"canSetProperty(String propertyName, Value[] values) must return true if the property is of type Double and values are of type LongValue", (boolean)nodeType.canSetProperty(propDef.getName(), longValues));
        Value booleanValue = NodeTypeUtil.getValueOfType(this.session, 6);
        Value[] booleanValues = new Value[]{doubleValue, booleanValue};
        CanSetPropertyDoubleTest.assertFalse((String)"canSetProperty(String propertyName, Value[] values) must return false if the property is of type Double and values are of type BooleanValue", (boolean)nodeType.canSetProperty(propDef.getName(), booleanValues));
        Value nameValue = NodeTypeUtil.getValueOfType(this.session, 7);
        Value[] nameValues = new Value[]{doubleValue, nameValue};
        CanSetPropertyDoubleTest.assertFalse((String)"canSetProperty(String propertyName, Value[] values) must return false if the property is of type Double and values are of type NameValue", (boolean)nodeType.canSetProperty(propDef.getName(), nameValues));
        Value pathValue = NodeTypeUtil.getValueOfType(this.session, 8);
        Value[] pathValues = new Value[]{doubleValue, pathValue};
        CanSetPropertyDoubleTest.assertFalse((String)"canSetProperty(String propertyName, Value[] values) must return false if the property is of type Double and values are of type PathValue", (boolean)nodeType.canSetProperty(propDef.getName(), pathValues));
    }

    public void testValueConstraintNotSatisfied() throws NotExecutableException, ParseException, RepositoryException {
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.session, 4, false, false, true, false);
        if (propDef == null) {
            throw new NotExecutableException("No double property def with testable value constraints has been found");
        }
        Value value = NodeTypeUtil.getValueAccordingToValueConstraints(this.session, propDef, false);
        if (value == null) {
            throw new NotExecutableException("No double property def with testable value constraints has been found");
        }
        NodeType nodeType = propDef.getDeclaringNodeType();
        CanSetPropertyDoubleTest.assertFalse((String)"canSetProperty(String propertyName, Value value) must return false if value does not match the value constraints.", (boolean)nodeType.canSetProperty(propDef.getName(), value));
    }

    public void testValueConstraintNotSatisfiedMultiple() throws NotExecutableException, ParseException, RepositoryException {
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.session, 4, true, false, true, false);
        if (propDef == null) {
            throw new NotExecutableException("No multiple double property def with testable value constraints has been found");
        }
        Value value = NodeTypeUtil.getValueAccordingToValueConstraints(this.session, propDef, false);
        if (value == null) {
            throw new NotExecutableException("No multiple double property def with testable value constraints has been found");
        }
        NodeType nodeType = propDef.getDeclaringNodeType();
        Value[] values = new Value[]{value};
        CanSetPropertyDoubleTest.assertFalse((String)"canSetProperty(String propertyName, Value[] values) must return false if values do not match the value constraints.", (boolean)nodeType.canSetProperty(propDef.getName(), values));
    }
}

